"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StabilityDaysMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class StabilityDaysMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'stabilityDays';
    run(value) {
        if (is_1.default.integer(value)) {
            let newValue;
            switch (value) {
                case 0:
                    newValue = null;
                    break;
                case 1:
                    newValue = '1 day';
                    break;
                default:
                    newValue = `${value} days`;
                    break;
            }
            this.setSafely('minimumReleaseAge', newValue);
        }
    }
}
exports.StabilityDaysMigration = StabilityDaysMigration;
//# sourceMappingURL=stability-days-migration.js.map