"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecreateClosedMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class RecreateClosedMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'recreateClosed';
    run(value) {
        if (is_1.default.boolean(value)) {
            this.setSafely('recreateWhen', value ? 'always' : 'auto');
        }
    }
}
exports.RecreateClosedMigration = RecreateClosedMigration;
//# sourceMappingURL=recreate-closed-migration.js.map