"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlatformCommitMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class PlatformCommitMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'platformCommit';
    run(value) {
        if (is_1.default.boolean(value)) {
            this.rewrite(value ? 'enabled' : 'disabled');
        }
    }
}
exports.PlatformCommitMigration = PlatformCommitMigration;
//# sourceMappingURL=platform-commit-migration.js.map