"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PathRulesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class PathRulesMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'pathRules';
    run(value) {
        const packageRules = this.get('packageRules');
        if (is_1.default.array(value)) {
            this.setHard('packageRules', is_1.default.array(packageRules) ? packageRules.concat(value) : value);
        }
    }
}
exports.PathRulesMigration = PathRulesMigration;
//# sourceMappingURL=path-rules-migration.js.map