"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeMigration = void 0;
const abstract_migration_1 = require("../base/abstract-migration");
class NodeMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'node';
    run(value) {
        const node = this.get('node');
        if (value.enabled === true) {
            // validated non-null
            delete node.enabled;
            const travis = (this.get('travis') ?? {});
            travis.enabled = true;
            if (Object.keys(node).length) {
                this.rewrite(node);
            }
            else {
                this.delete('node');
            }
            this.setSafely('travis', travis);
        }
    }
}
exports.NodeMigration = NodeMigration;
//# sourceMappingURL=node-migration.js.map