"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileMatchMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class FileMatchMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'fileMatch';
    run(value) {
        if (is_1.default.string(value) || is_1.default.array(value, is_1.default.string)) {
            const fileMatch = is_1.default.array(value) ? value : [value];
            let managerFilePatterns = this.get('managerFilePatterns') ?? [];
            managerFilePatterns = managerFilePatterns.concat(fileMatch.map((match) => `/${match}/`));
            this.setHard('managerFilePatterns', managerFilePatterns);
        }
    }
}
exports.FileMatchMigration = FileMatchMigration;
//# sourceMappingURL=file-match-migration.js.map