"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DepTypesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class DepTypesMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = /^(?:(?:d|devD|optionalD|peerD)ependencies|engines|depTypes)$/;
    run(value, key) {
        const packageRules = this.get('packageRules') ?? [];
        if (is_1.default.nonEmptyObject(value) && !is_1.default.array(value)) {
            packageRules.push({
                matchDepTypes: [key],
                ...value,
            });
        }
        if (is_1.default.array(value)) {
            for (const depType of value) {
                if (is_1.default.object(depType) && !is_1.default.array(depType)) {
                    const depTypeName = depType.depType;
                    if (depTypeName) {
                        delete depType.depType;
                        depType.matchDepTypes = [depTypeName];
                        packageRules.push({ ...depType });
                    }
                }
            }
        }
        if (packageRules.length) {
            this.setHard('packageRules', packageRules);
        }
    }
}
exports.DepTypesMigration = DepTypesMigration;
//# sourceMappingURL=dep-types-migration.js.map