"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatasourceMigration = void 0;
exports.migrateDatasource = migrateDatasource;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class DatasourceMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'datasource';
    run(value) {
        if (is_1.default.string(value)) {
            const newValue = migrateDatasource(value);
            this.rewrite(newValue);
        }
    }
}
exports.DatasourceMigration = DatasourceMigration;
function migrateDatasource(value) {
    switch (value) {
        case 'adoptium-java':
            return 'java-version';
        case 'dotnet':
            return 'dotnet-version';
        case 'node':
            return 'node-version';
    }
    return value;
}
//# sourceMappingURL=datasource-migration.js.map