"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomManagersMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class CustomManagersMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'customManagers';
    run(value) {
        if (is_1.default.nonEmptyArray(value)) {
            const customManagers = value.map((mgr) => {
                if (mgr.customType) {
                    return mgr;
                }
                return Object.assign({ customType: 'regex' }, mgr); // to make sure customType is at top, looks good when migration PR is created
            });
            this.rewrite(customManagers);
        }
    }
}
exports.CustomManagersMigration = CustomManagersMigration;
//# sourceMappingURL=custom-managers-migration.js.map