"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.migrateAndValidate = migrateAndValidate;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const dequal_1 = require("dequal");
const logger_1 = require("../logger");
const configMassage = tslib_1.__importStar(require("./massage"));
const configMigration = tslib_1.__importStar(require("./migration"));
const configValidation = tslib_1.__importStar(require("./validation"));
async function migrateAndValidate(config, input) {
    logger_1.logger.debug('migrateAndValidate()');
    try {
        const { isMigrated, migratedConfig } = configMigration.migrateConfig(input);
        if (isMigrated) {
            logger_1.logger.debug({ oldConfig: input, newConfig: migratedConfig }, 'Config migration necessary');
        }
        else {
            logger_1.logger.debug('No config migration necessary');
        }
        const massagedConfig = configMassage.massageConfig(migratedConfig);
        // log only if it's changed
        if (!(0, dequal_1.dequal)(input, massagedConfig)) {
            logger_1.logger.debug({ config: massagedConfig }, 'Post-massage config');
        }
        const { warnings, errors, } = await configValidation.validateConfig('repo', massagedConfig);
        /* v8 ignore start -- hard to test */
        if (is_1.default.nonEmptyArray(warnings)) {
            logger_1.logger.warn({ warnings }, 'Found renovate config warnings');
        }
        if (is_1.default.nonEmptyArray(errors)) {
            logger_1.logger.info({ errors }, 'Found renovate config errors');
        }
        massagedConfig.errors = (config.errors ?? []).concat(errors);
        if (!config.repoIsOnboarded) {
            massagedConfig.warnings = (config.warnings ?? []).concat(warnings);
        }
        return massagedConfig;
        /* v8 ignore next 3 -- TODO: add test */
    }
    catch (err) {
        logger_1.logger.debug({ config: input }, 'migrateAndValidate error');
        throw err;
    }
}
//# sourceMappingURL=migrate-validate.js.map