"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalConfig = void 0;
class GlobalConfig {
    // TODO: once global config work is complete, add a test to make sure this list includes all options with globalOnly=true (#9603)
    static OPTIONS = [
        'allowedCommands',
        'allowedEnv',
        'allowCustomCrateRegistries',
        'allowedHeaders',
        'allowPlugins',
        'allowScripts',
        'binarySource',
        'cacheDir',
        'cacheHardTtlMinutes',
        'cacheTtlOverride',
        'containerbaseDir',
        'customEnvVariables',
        'dockerChildPrefix',
        'dockerCliOptions',
        'dockerSidecarImage',
        'dockerUser',
        'dryRun',
        'encryptedWarning',
        'exposeAllEnv',
        'executionTimeout',
        'githubTokenWarn',
        'localDir',
        'migratePresets',
        'presetCachePersistence',
        'gitTimeout',
        'platform',
        'endpoint',
        'httpCacheTtlDays',
        'autodiscoverRepoSort',
        'autodiscoverRepoOrder',
        'userAgent',
        'dockerMaxPages',
        's3Endpoint',
        's3PathStyle',
        'cachePrivatePackages',
    ];
    static config = {};
    static get(key, defaultValue) {
        return key
            ? (GlobalConfig.config[key] ?? defaultValue)
            : GlobalConfig.config;
    }
    static set(config) {
        GlobalConfig.reset();
        const result = { ...config };
        for (const option of GlobalConfig.OPTIONS) {
            GlobalConfig.config[option] = config[option];
            delete result[option];
        }
        return result;
    }
    static reset() {
        GlobalConfig.config = {};
    }
}
exports.GlobalConfig = GlobalConfig;
//# sourceMappingURL=global.js.map