"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryDecryptPublicKeyPKCS1 = tryDecryptPublicKeyPKCS1;
exports.tryDecryptPublicKeyDefault = tryDecryptPublicKeyDefault;
const tslib_1 = require("tslib");
const node_crypto_1 = tslib_1.__importDefault(require("node:crypto"));
const logger_1 = require("../../logger");
function tryDecryptPublicKeyPKCS1(privateKey, encryptedStr) {
    let decryptedStr = null;
    try {
        decryptedStr = node_crypto_1.default
            .privateDecrypt({
            key: privateKey,
            padding: node_crypto_1.default.constants.RSA_PKCS1_PADDING,
        }, Buffer.from(encryptedStr, 'base64'))
            .toString();
    }
    catch {
        logger_1.logger.debug('Could not decrypt using PKCS1 padding');
    }
    return decryptedStr;
}
function tryDecryptPublicKeyDefault(privateKey, encryptedStr) {
    let decryptedStr = null;
    try {
        decryptedStr = node_crypto_1.default
            .privateDecrypt(privateKey, Buffer.from(encryptedStr, 'base64'))
            .toString();
        logger_1.logger.debug('Decrypted config using default padding');
    }
    catch {
        logger_1.logger.debug('Could not decrypt using default padding');
    }
    return decryptedStr;
}
//# sourceMappingURL=legacy.js.map