"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryDecryptKbPgp = tryDecryptKbPgp;
const tslib_1 = require("tslib");
const kbpgp = tslib_1.__importStar(require("@renovatebot/kbpgp"));
const logger_1 = require("../../logger");
const regex_1 = require("../../util/regex");
async function tryDecryptKbPgp(privateKey, encryptedStr) {
    if (encryptedStr.length < 500) {
        // optimization during transition of public key -> pgp
        return null;
    }
    try {
        const pk = await new Promise((resolve, reject) => {
            kbpgp.KeyManager.import_from_armored_pgp({
                armored: privateKey.replace((0, regex_1.regEx)(/\n[ \t]+/g), '\n'),
            }, (err, pk) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(pk);
                }
            });
        });
        const ring = new kbpgp.keyring.KeyRing();
        ring.add_key_manager(pk);
        const startBlock = '-----BEGIN PGP MESSAGE-----\n\n';
        const endBlock = '\n-----END PGP MESSAGE-----';
        let armoredMessage = encryptedStr.trim();
        if (!armoredMessage.startsWith(startBlock)) {
            armoredMessage = `${startBlock}${armoredMessage}`;
        }
        if (!armoredMessage.endsWith(endBlock)) {
            armoredMessage = `${armoredMessage}${endBlock}`;
        }
        const data = await new Promise((resolve, reject) => {
            kbpgp.unbox({
                keyfetch: ring,
                armored: armoredMessage,
            }, (err, literals) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(literals[0].toString());
                }
            });
        });
        logger_1.logger.debug('Decrypted config using kppgp');
        return data;
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'Could not decrypt using kppgp');
        return null;
    }
}
//# sourceMappingURL=kbpgp.js.map