"use strict";
/**
 * Copyright (c) Jonathan Cardoso Machado. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
// This file was generated by scripts/build-constants.js on 2021-09-19T20:27:02.038Z
// Do not edit manually
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurlOptionCamelCaseMap = void 0;
exports.CurlOptionCamelCaseMap = {
    /**
     * Path to an abstract Unix domain socket.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ABSTRACT_UNIX_SOCKET.html](https://curl.haxx.se/libcurl/c/CURLOPT_ABSTRACT_UNIX_SOCKET.html)
     */
    abstractUnixSocket: 'ABSTRACT_UNIX_SOCKET',
    /**
     * Accept-Encoding and automatic decompressing data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ACCEPT_ENCODING.html](https://curl.haxx.se/libcurl/c/CURLOPT_ACCEPT_ENCODING.html)
     */
    acceptEncoding: 'ACCEPT_ENCODING',
    /**
     * Timeout for waiting for the server's connect back to be accepted.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ACCEPTTIMEOUT_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_ACCEPTTIMEOUT_MS.html)
     */
    acceptTimeoutMs: 'ACCEPTTIMEOUT_MS',
    /**
     * IPv6 scope for local addresses.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ADDRESS_SCOPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_ADDRESS_SCOPE.html)
     */
    addressScope: 'ADDRESS_SCOPE',
    /**
     * Specify the Alt-Svc: cache file name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ALTSVC.html](https://curl.haxx.se/libcurl/c/CURLOPT_ALTSVC.html)
     */
    altSvc: 'ALTSVC',
    /**
     * Enable and configure Alt-Svc: treatment.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ALTSVC_CTRL.html](https://curl.haxx.se/libcurl/c/CURLOPT_ALTSVC_CTRL.html)
     */
    altSvcCtrl: 'ALTSVC_CTRL',
    /**
     * Append to remote file.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_APPEND.html](https://curl.haxx.se/libcurl/c/CURLOPT_APPEND.html)
     */
    append: 'APPEND',
    /**
     * Automatically set Referer: header.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_AUTOREFERER.html](https://curl.haxx.se/libcurl/c/CURLOPT_AUTOREFERER.html)
     */
    autoReferer: 'AUTOREFERER',
    /**
     * AWS HTTP V4 Signature.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_AWS_SIGV4.html](https://curl.haxx.se/libcurl/c/CURLOPT_AWS_SIGV4.html)
     */
    awsSigV4: 'AWS_SIGV4',
    /**
     * Ask for alternate buffer size.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_BUFFERSIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_BUFFERSIZE.html)
     */
    bufferSize: 'BUFFERSIZE',
    /**
     * CA cert bundle.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CAINFO.html](https://curl.haxx.se/libcurl/c/CURLOPT_CAINFO.html)
     */
    caInfo: 'CAINFO',
    /**
     * CA cert bundle memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CAINFO_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_CAINFO_BLOB.html)
     */
    caInfoBlob: 'CAINFO_BLOB',
    /**
     * Path to CA cert bundle.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CAPATH.html](https://curl.haxx.se/libcurl/c/CURLOPT_CAPATH.html)
     */
    caPath: 'CAPATH',
    /**
     * Extract certificate info.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CERTINFO.html](https://curl.haxx.se/libcurl/c/CURLOPT_CERTINFO.html)
     */
    certInfo: 'CERTINFO',
    /**
     * Callback for wildcard download start of chunk.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CHUNK_BGN_FUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_CHUNK_BGN_FUNCTION.html)
     */
    chunkBgnFunction: 'CHUNK_BGN_FUNCTION',
    /**
     * Callback for wildcard download end of chunk.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CHUNK_END_FUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_CHUNK_END_FUNCTION.html)
     */
    chunkEndFunction: 'CHUNK_END_FUNCTION',
    /**
     * Only connect, nothing else.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CONNECT_ONLY.html](https://curl.haxx.se/libcurl/c/CURLOPT_CONNECT_ONLY.html)
     */
    connectOnly: 'CONNECT_ONLY',
    /**
     * Connect to a specific host and port.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CONNECT_TO.html](https://curl.haxx.se/libcurl/c/CURLOPT_CONNECT_TO.html)
     */
    connectTo: 'CONNECT_TO',
    /**
     * Timeout for the connection phase.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html](https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT.html)
     */
    connectTimeout: 'CONNECTTIMEOUT',
    /**
     * Millisecond timeout for the connection phase.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_CONNECTTIMEOUT_MS.html)
     */
    connectTimeoutMs: 'CONNECTTIMEOUT_MS',
    /**
     * Cookie(s) to send.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_COOKIE.html](https://curl.haxx.se/libcurl/c/CURLOPT_COOKIE.html)
     */
    cookie: 'COOKIE',
    /**
     * File to read cookies from.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_COOKIEFILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_COOKIEFILE.html)
     */
    cookieFile: 'COOKIEFILE',
    /**
     * File to write cookies to.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_COOKIEJAR.html](https://curl.haxx.se/libcurl/c/CURLOPT_COOKIEJAR.html)
     */
    cookieJar: 'COOKIEJAR',
    /**
     * Add or control cookies.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_COOKIELIST.html](https://curl.haxx.se/libcurl/c/CURLOPT_COOKIELIST.html)
     */
    cookieList: 'COOKIELIST',
    /**
     * Start a new cookie session.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_COOKIESESSION.html](https://curl.haxx.se/libcurl/c/CURLOPT_COOKIESESSION.html)
     */
    cookieSession: 'COOKIESESSION',
    /**
     * Convert newlines.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CRLF.html](https://curl.haxx.se/libcurl/c/CURLOPT_CRLF.html)
     */
    crlf: 'CRLF',
    /**
     * Certificate Revocation List.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CRLFILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_CRLFILE.html)
     */
    crlFile: 'CRLFILE',
    /**
     * Custom request/method.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_CUSTOMREQUEST.html](https://curl.haxx.se/libcurl/c/CURLOPT_CUSTOMREQUEST.html)
     */
    customRequest: 'CUSTOMREQUEST',
    /**
     * Callback for debug information.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DEBUGFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_DEBUGFUNCTION.html)
     */
    debugFunction: 'DEBUGFUNCTION',
    /**
     * Default protocol.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DEFAULT_PROTOCOL.html](https://curl.haxx.se/libcurl/c/CURLOPT_DEFAULT_PROTOCOL.html)
     */
    defaultProtocol: 'DEFAULT_PROTOCOL',
    /**
     * List only.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DIRLISTONLY.html](https://curl.haxx.se/libcurl/c/CURLOPT_DIRLISTONLY.html)
     */
    dirListOnly: 'DIRLISTONLY',
    /**
     * Don't allow username in URL.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DISALLOW_USERNAME_IN_URL.html](https://curl.haxx.se/libcurl/c/CURLOPT_DISALLOW_USERNAME_IN_URL.html)
     */
    disallowUsernameInUrl: 'DISALLOW_USERNAME_IN_URL',
    /**
     * Timeout for DNS cache.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_CACHE_TIMEOUT.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_CACHE_TIMEOUT.html)
     */
    dnsCacheTimeout: 'DNS_CACHE_TIMEOUT',
    /**
     * Bind name resolves to this interface.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_INTERFACE.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_INTERFACE.html)
     */
    dnsInterface: 'DNS_INTERFACE',
    /**
     * Bind name resolves to this IP4 address.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_LOCAL_IP4.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_LOCAL_IP4.html)
     */
    dnsLocalIp4: 'DNS_LOCAL_IP4',
    /**
     * Bind name resolves to this IP6 address.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_LOCAL_IP6.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_LOCAL_IP6.html)
     */
    dnsLocalIp6: 'DNS_LOCAL_IP6',
    /**
     * Preferred DNS servers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_SERVERS.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_SERVERS.html)
     */
    dnsServers: 'DNS_SERVERS',
    /**
     * Shuffle addresses before use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_SHUFFLE_ADDRESSES.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_SHUFFLE_ADDRESSES.html)
     */
    dnsShuffleAddresses: 'DNS_SHUFFLE_ADDRESSES',
    /**
     * OBSOLETE Enable global DNS cache.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DNS_USE_GLOBAL_CACHE.html](https://curl.haxx.se/libcurl/c/CURLOPT_DNS_USE_GLOBAL_CACHE.html)
     */
    dnsUseGlobalCache: 'DNS_USE_GLOBAL_CACHE',
    /**
     * Verify the host name in the DoH (DNS-over-HTTPS) SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYHOST.html](https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYHOST.html)
     */
    dohSslVerifyHost: 'DOH_SSL_VERIFYHOST',
    /**
     * Verify the DoH (DNS-over-HTTPS) SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYPEER.html](https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYPEER.html)
     */
    dohSslVerifyPeer: 'DOH_SSL_VERIFYPEER',
    /**
     * Verify the DoH (DNS-over-HTTPS) SSL certificate's status.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYSTATUS.html](https://curl.haxx.se/libcurl/c/CURLOPT_DOH_SSL_VERIFYSTATUS.html)
     */
    dohSslVerifyStatus: 'DOH_SSL_VERIFYSTATUS',
    /**
     * Use this DoH server for name resolves.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_DOH_URL.html](https://curl.haxx.se/libcurl/c/CURLOPT_DOH_URL.html)
     */
    dohUrl: 'DOH_URL',
    /**
     * Identify EGD socket for entropy.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_EGDSOCKET.html](https://curl.haxx.se/libcurl/c/CURLOPT_EGDSOCKET.html)
     */
    egdSocket: 'EGDSOCKET',
    /**
     * 100-continue timeout.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_EXPECT_100_TIMEOUT_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_EXPECT_100_TIMEOUT_MS.html)
     */
    expect100TimeoutMs: 'EXPECT_100_TIMEOUT_MS',
    /**
     * Fail on HTTP 4xx errors.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FAILONERROR.html](https://curl.haxx.se/libcurl/c/CURLOPT_FAILONERROR.html)
     */
    failOnError: 'FAILONERROR',
    /**
     * Request file modification date and time.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FILETIME.html](https://curl.haxx.se/libcurl/c/CURLOPT_FILETIME.html)
     */
    fileTime: 'FILETIME',
    /**
     * Callback for wildcard matching.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FNMATCH_FUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_FNMATCH_FUNCTION.html)
     */
    fnMatchFunction: 'FNMATCH_FUNCTION',
    /**
     * Follow HTTP redirects.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FOLLOWLOCATION.html](https://curl.haxx.se/libcurl/c/CURLOPT_FOLLOWLOCATION.html)
     */
    followLocation: 'FOLLOWLOCATION',
    /**
     * Prevent subsequent connections from re-using this.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FORBID_REUSE.html](https://curl.haxx.se/libcurl/c/CURLOPT_FORBID_REUSE.html)
     */
    forbIdReuse: 'FORBID_REUSE',
    /**
     * Use a new connection.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FRESH_CONNECT.html](https://curl.haxx.se/libcurl/c/CURLOPT_FRESH_CONNECT.html)
     */
    freshConnect: 'FRESH_CONNECT',
    /**
     * Send ACCT command.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_ACCOUNT.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_ACCOUNT.html)
     */
    ftpAccount: 'FTP_ACCOUNT',
    /**
     * Alternative to USER.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_ALTERNATIVE_TO_USER.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_ALTERNATIVE_TO_USER.html)
     */
    ftpAlternativeToUser: 'FTP_ALTERNATIVE_TO_USER',
    /**
     * Create missing directories on the remote server.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_CREATE_MISSING_DIRS.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_CREATE_MISSING_DIRS.html)
     */
    ftpCreateMissingDirs: 'FTP_CREATE_MISSING_DIRS',
    /**
     * Specify how to reach files.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_FILEMETHOD.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_FILEMETHOD.html)
     */
    ftpFileMethod: 'FTP_FILEMETHOD',
    /**
     * Timeout for FTP responses.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_RESPONSE_TIMEOUT.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_RESPONSE_TIMEOUT.html)
     */
    ftpResponseTimeout: 'FTP_RESPONSE_TIMEOUT',
    /**
     * Ignore the IP address in the PASV response.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_SKIP_PASV_IP.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_SKIP_PASV_IP.html)
     */
    ftpSkipPasvIp: 'FTP_SKIP_PASV_IP',
    /**
     * Back to non-TLS again after authentication.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_SSL_CCC.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_SSL_CCC.html)
     */
    ftpSslCcc: 'FTP_SSL_CCC',
    /**
     * Use EPTR.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_EPRT.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_EPRT.html)
     */
    ftpUseEprt: 'FTP_USE_EPRT',
    /**
     * Use EPSV.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_EPSV.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_EPSV.html)
     */
    ftpUseEpsv: 'FTP_USE_EPSV',
    /**
     * Use PRET.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_PRET.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTP_USE_PRET.html)
     */
    ftpUsePret: 'FTP_USE_PRET',
    /**
     * Use active FTP.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTPPORT.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTPPORT.html)
     */
    ftpPort: 'FTPPORT',
    /**
     * Control how to do TLS.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_FTPSSLAUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_FTPSSLAUTH.html)
     */
    ftpSslAuth: 'FTPSSLAUTH',
    /**
     * Disable GSS-API delegation.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_GSSAPI_DELEGATION.html](https://curl.haxx.se/libcurl/c/CURLOPT_GSSAPI_DELEGATION.html)
     */
    gssapiDelegation: 'GSSAPI_DELEGATION',
    /**
     * Timeout for happy eyeballs.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HAPPY_EYEBALLS_TIMEOUT_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_HAPPY_EYEBALLS_TIMEOUT_MS.html)
     */
    happyEyeballsTimeoutMs: 'HAPPY_EYEBALLS_TIMEOUT_MS',
    /**
     * Send an HAProxy PROXY protocol v1 header.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HAPROXYPROTOCOL.html](https://curl.haxx.se/libcurl/c/CURLOPT_HAPROXYPROTOCOL.html)
     */
    haProxyProtocol: 'HAPROXYPROTOCOL',
    /**
     * Include the header in the body output.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HEADER.html](https://curl.haxx.se/libcurl/c/CURLOPT_HEADER.html)
     */
    header: 'HEADER',
    /**
     * Callback for writing received headers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HEADERFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_HEADERFUNCTION.html)
     */
    headerFunction: 'HEADERFUNCTION',
    /**
     * Control custom headers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HEADEROPT.html](https://curl.haxx.se/libcurl/c/CURLOPT_HEADEROPT.html)
     */
    headerOpt: 'HEADEROPT',
    /**
     * Set HSTS cache file.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HSTS.html](https://curl.haxx.se/libcurl/c/CURLOPT_HSTS.html)
     */
    hsts: 'HSTS',
    /**
     * Enable HSTS.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HSTS_CTRL.html](https://curl.haxx.se/libcurl/c/CURLOPT_HSTS_CTRL.html)
     */
    hstsCtrl: 'HSTS_CTRL',
    /**
     * Set HSTS read callback.
     *
     * You can either return a single `CurlHstsReadCallbackResult` object or an array of `CurlHstsReadCallbackResult` objects.
     * If returning an array, the callback will only be called once per request.
     * If returning a single object, the callback will be called multiple times until `null` is returned.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HSTSREADFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_HSTSREADFUNCTION.html)
     */
    hstsReadFunction: 'HSTSREADFUNCTION',
    /**
     * Set HSTS write callback.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HSTSWRITEFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_HSTSWRITEFUNCTION.html)
     */
    hstsWriteFunction: 'HSTSWRITEFUNCTION',
    /**
     * Disable Content decoding.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_CONTENT_DECODING.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_CONTENT_DECODING.html)
     */
    httpContentDecoding: 'HTTP_CONTENT_DECODING',
    /**
     * Disable Transfer decoding.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_TRANSFER_DECODING.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_TRANSFER_DECODING.html)
     */
    httpTransferDecoding: 'HTTP_TRANSFER_DECODING',
    /**
     * HTTP version to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_VERSION.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTP_VERSION.html)
     */
    httpVersion: 'HTTP_VERSION',
    /**
     * Allow HTTP/0.9 responses.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTP09_ALLOWED.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTP09_ALLOWED.html)
     */
    http09Allowed: 'HTTP09_ALLOWED',
    /**
     * Alternative versions of 200 OK.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTP200ALIASES.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTP200ALIASES.html)
     */
    http200aliases: 'HTTP200ALIASES',
    /**
     * HTTP server authentication methods.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTPAUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTPAUTH.html)
     */
    httpAuth: 'HTTPAUTH',
    /**
     * Do an HTTP GET request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTPGET.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTPGET.html)
     */
    httpGet: 'HTTPGET',
    /**
     * Custom HTTP headers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTPHEADER.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTPHEADER.html)
     */
    httpHeader: 'HTTPHEADER',
    /**
     * Multipart formpost HTTP POST.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTPPOST.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTPPOST.html)
     */
    httpPost: 'HTTPPOST',
    /**
     * Tunnel through the HTTP proxy.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_HTTPPROXYTUNNEL.html](https://curl.haxx.se/libcurl/c/CURLOPT_HTTPPROXYTUNNEL.html)
     */
    httpProxyTunnel: 'HTTPPROXYTUNNEL',
    /**
     * Ignore Content-Length.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_IGNORE_CONTENT_LENGTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_IGNORE_CONTENT_LENGTH.html)
     */
    ignoreContentLength: 'IGNORE_CONTENT_LENGTH',
    /**
     * Size of file to send.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_INFILESIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_INFILESIZE.html)
     */
    inFileSize: 'INFILESIZE',
    /**
     * Size of file to send.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_INFILESIZE_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_INFILESIZE_LARGE.html)
     */
    inFileSizeLarge: 'INFILESIZE_LARGE',
    /**
     * Bind connection locally to this.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_INTERFACE.html](https://curl.haxx.se/libcurl/c/CURLOPT_INTERFACE.html)
     */
    interface: 'INTERFACE',
    /**
     * IP version to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_IPRESOLVE.html](https://curl.haxx.se/libcurl/c/CURLOPT_IPRESOLVE.html)
     */
    ipResolve: 'IPRESOLVE',
    /**
     * Issuer certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ISSUERCERT.html](https://curl.haxx.se/libcurl/c/CURLOPT_ISSUERCERT.html)
     */
    issuerCert: 'ISSUERCERT',
    /**
     * Issuer certificate memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_ISSUERCERT_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_ISSUERCERT_BLOB.html)
     */
    issuerCertBlob: 'ISSUERCERT_BLOB',
    /**
     * Keep sending on HTTP \>= 300 errors.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_KEEP_SENDING_ON_ERROR.html](https://curl.haxx.se/libcurl/c/CURLOPT_KEEP_SENDING_ON_ERROR.html)
     */
    keepSendingOnError: 'KEEP_SENDING_ON_ERROR',
    /**
     * Client key password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_KEYPASSWD.html](https://curl.haxx.se/libcurl/c/CURLOPT_KEYPASSWD.html)
     */
    keyPasswd: 'KEYPASSWD',
    /**
     * Kerberos security level.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_KRBLEVEL.html](https://curl.haxx.se/libcurl/c/CURLOPT_KRBLEVEL.html)
     */
    krbLevel: 'KRBLEVEL',
    /**
     * Bind connection locally to this port.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_LOCALPORT.html](https://curl.haxx.se/libcurl/c/CURLOPT_LOCALPORT.html)
     */
    localPort: 'LOCALPORT',
    /**
     * Bind connection locally to port range.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_LOCALPORTRANGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_LOCALPORTRANGE.html)
     */
    localPortRange: 'LOCALPORTRANGE',
    /**
     * Login options.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_LOGIN_OPTIONS.html](https://curl.haxx.se/libcurl/c/CURLOPT_LOGIN_OPTIONS.html)
     */
    loginOptions: 'LOGIN_OPTIONS',
    /**
     * Low speed limit to abort transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html](https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_LIMIT.html)
     */
    lowSpeedLimit: 'LOW_SPEED_LIMIT',
    /**
     * Time to be below the speed to trigger low speed abort.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html](https://curl.haxx.se/libcurl/c/CURLOPT_LOW_SPEED_TIME.html)
     */
    lowSpeedTime: 'LOW_SPEED_TIME',
    /**
     * Authentication address.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_AUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_AUTH.html)
     */
    mailAuth: 'MAIL_AUTH',
    /**
     * Address of the sender.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_FROM.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_FROM.html)
     */
    mailFrom: 'MAIL_FROM',
    /**
     * Address of the recipients.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_RCPT.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_RCPT.html)
     */
    mailRcpt: 'MAIL_RCPT',
    /**
     * Allow RCPT TO command to fail for some recipients.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_RCPT_ALLLOWFAILS.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAIL_RCPT_ALLLOWFAILS.html)
     */
    mailRcptAlllowfails: 'MAIL_RCPT_ALLLOWFAILS',
    /**
     * Cap the download speed to this.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAX_RECV_SPEED_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAX_RECV_SPEED_LARGE.html)
     */
    maxRecvSpeedLarge: 'MAX_RECV_SPEED_LARGE',
    /**
     * Cap the upload speed to this.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAX_SEND_SPEED_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAX_SEND_SPEED_LARGE.html)
     */
    maxSendSpeedLarge: 'MAX_SEND_SPEED_LARGE',
    /**
     * Limit the age of connections for reuse.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAXAGE_CONN.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAXAGE_CONN.html)
     */
    maxAgeConn: 'MAXAGE_CONN',
    /**
     * Maximum number of connections in the connection pool.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAXCONNECTS.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAXCONNECTS.html)
     */
    maxConnects: 'MAXCONNECTS',
    /**
     * Maximum file size to get.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAXFILESIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAXFILESIZE.html)
     */
    maxFileSize: 'MAXFILESIZE',
    /**
     * Maximum file size to get.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAXFILESIZE_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAXFILESIZE_LARGE.html)
     */
    maxFileSizeLarge: 'MAXFILESIZE_LARGE',
    /**
     * Maximum number of redirects to follow.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MAXREDIRS.html](https://curl.haxx.se/libcurl/c/CURLOPT_MAXREDIRS.html)
     */
    maxRedirs: 'MAXREDIRS',
    /**
     * Post/send MIME data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_MIMEPOST.html](https://curl.haxx.se/libcurl/c/CURLOPT_MIMEPOST.html)
     */
    mimePost: 'MIMEPOST',
    /**
     * Enable .netrc parsing.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NETRC.html](https://curl.haxx.se/libcurl/c/CURLOPT_NETRC.html)
     */
    netrc: 'NETRC',
    /**
     * .netrc file name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NETRC_FILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_NETRC_FILE.html)
     */
    netrcFile: 'NETRC_FILE',
    /**
     * Mode for creating new remote directories.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NEW_DIRECTORY_PERMS.html](https://curl.haxx.se/libcurl/c/CURLOPT_NEW_DIRECTORY_PERMS.html)
     */
    newDirectoryPerms: 'NEW_DIRECTORY_PERMS',
    /**
     * Mode for creating new remote files.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NEW_FILE_PERMS.html](https://curl.haxx.se/libcurl/c/CURLOPT_NEW_FILE_PERMS.html)
     */
    newFilePerms: 'NEW_FILE_PERMS',
    /**
     * Do not get the body contents.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NOBODY.html](https://curl.haxx.se/libcurl/c/CURLOPT_NOBODY.html)
     */
    nobody: 'NOBODY',
    /**
     * Shut off the progress meter.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NOPROGRESS.html](https://curl.haxx.se/libcurl/c/CURLOPT_NOPROGRESS.html)
     */
    noProgress: 'NOPROGRESS',
    /**
     * Filter out hosts from proxy use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NOPROXY.html](https://curl.haxx.se/libcurl/c/CURLOPT_NOPROXY.html)
     */
    noProxy: 'NOPROXY',
    /**
     * Do not install signal handlers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_NOSIGNAL.html](https://curl.haxx.se/libcurl/c/CURLOPT_NOSIGNAL.html)
     */
    noSignal: 'NOSIGNAL',
    /**
     * Password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PASSWORD.html](https://curl.haxx.se/libcurl/c/CURLOPT_PASSWORD.html)
     */
    password: 'PASSWORD',
    /**
     * Disable squashing /../ and /./ sequences in the path.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PATH_AS_IS.html](https://curl.haxx.se/libcurl/c/CURLOPT_PATH_AS_IS.html)
     */
    pathAsIs: 'PATH_AS_IS',
    /**
     * Set pinned SSL public key .
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PINNEDPUBLICKEY.html](https://curl.haxx.se/libcurl/c/CURLOPT_PINNEDPUBLICKEY.html)
     */
    pinnedPublicKey: 'PINNEDPUBLICKEY',
    /**
     * Wait on connection to pipeline on it.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PIPEWAIT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PIPEWAIT.html)
     */
    pipeWait: 'PIPEWAIT',
    /**
     * Port number to connect to.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PORT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PORT.html)
     */
    port: 'PORT',
    /**
     * Issue an HTTP POST request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POST.html](https://curl.haxx.se/libcurl/c/CURLOPT_POST.html)
     */
    post: 'POST',
    /**
     * Send a POST with this data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDS.html](https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDS.html)
     */
    postFields: 'POSTFIELDS',
    /**
     * The POST data is this big.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDSIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDSIZE.html)
     */
    postFieldSize: 'POSTFIELDSIZE',
    /**
     * The POST data is this big.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDSIZE_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_POSTFIELDSIZE_LARGE.html)
     */
    postFieldSizeLarge: 'POSTFIELDSIZE_LARGE',
    /**
     * Commands to run after transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POSTQUOTE.html](https://curl.haxx.se/libcurl/c/CURLOPT_POSTQUOTE.html)
     */
    postQuote: 'POSTQUOTE',
    /**
     * How to act on redirects after POST.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_POSTREDIR.html](https://curl.haxx.se/libcurl/c/CURLOPT_POSTREDIR.html)
     */
    postRedir: 'POSTREDIR',
    /**
     * Socks proxy to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PRE_PROXY.html](https://curl.haxx.se/libcurl/c/CURLOPT_PRE_PROXY.html)
     */
    preProxy: 'PRE_PROXY',
    /**
     * Commands to run just before transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PREQUOTE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PREQUOTE.html)
     */
    preQuote: 'PREQUOTE',
    /**
     * OBSOLETE callback for progress meter.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROGRESSFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROGRESSFUNCTION.html)
     */
    progressFunction: 'PROGRESSFUNCTION',
    /**
     * Allowed protocols.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROTOCOLS.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROTOCOLS.html)
     */
    protocols: 'PROTOCOLS',
    /**
     * Proxy to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY.html)
     */
    proxy: 'PROXY',
    /**
     * Proxy CA cert bundle.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAINFO.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAINFO.html)
     */
    proxyCaInfo: 'PROXY_CAINFO',
    /**
     * Proxy CA cert bundle memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAINFO_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAINFO_BLOB.html)
     */
    proxyCaInfoBlob: 'PROXY_CAINFO_BLOB',
    /**
     * Path to proxy CA cert bundle.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAPATH.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CAPATH.html)
     */
    proxyCaPath: 'PROXY_CAPATH',
    /**
     * Proxy Certificate Revocation List.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CRLFILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_CRLFILE.html)
     */
    proxyCrlFile: 'PROXY_CRLFILE',
    /**
     * Proxy issuer certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_ISSUERCERT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_ISSUERCERT.html)
     */
    proxyIssuerCert: 'PROXY_ISSUERCERT',
    /**
     * Proxy issuer certificate memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_ISSUERCERT_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_ISSUERCERT_BLOB.html)
     */
    proxyIssuerCertBlob: 'PROXY_ISSUERCERT_BLOB',
    /**
     * Proxy client key password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_KEYPASSWD.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_KEYPASSWD.html)
     */
    proxyKeyPasswd: 'PROXY_KEYPASSWD',
    /**
     * Set the proxy's pinned SSL public key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_PINNEDPUBLICKEY.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_PINNEDPUBLICKEY.html)
     */
    proxyPinnedPublicKey: 'PROXY_PINNEDPUBLICKEY',
    /**
     * Proxy authentication service name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SERVICE_NAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SERVICE_NAME.html)
     */
    proxyServiceName: 'PROXY_SERVICE_NAME',
    /**
     * Proxy ciphers to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_CIPHER_LIST.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_CIPHER_LIST.html)
     */
    proxySslCipherList: 'PROXY_SSL_CIPHER_LIST',
    /**
     * Control proxy SSL behavior.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_OPTIONS.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_OPTIONS.html)
     */
    proxySslOptions: 'PROXY_SSL_OPTIONS',
    /**
     * Verify the host name in the proxy SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_VERIFYHOST.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_VERIFYHOST.html)
     */
    proxySslVerifyHost: 'PROXY_SSL_VERIFYHOST',
    /**
     * Verify the proxy SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_VERIFYPEER.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSL_VERIFYPEER.html)
     */
    proxySslVerifyPeer: 'PROXY_SSL_VERIFYPEER',
    /**
     * Proxy client cert.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERT.html)
     */
    proxySslCert: 'PROXY_SSLCERT',
    /**
     * Proxy client cert memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERT_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERT_BLOB.html)
     */
    proxySslCertBlob: 'PROXY_SSLCERT_BLOB',
    /**
     * Proxy client cert type.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERTTYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLCERTTYPE.html)
     */
    proxySslCertType: 'PROXY_SSLCERTTYPE',
    /**
     * Proxy client key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEY.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEY.html)
     */
    proxySslKey: 'PROXY_SSLKEY',
    /**
     * Proxy client key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEY_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEY_BLOB.html)
     */
    proxySslKeyBlob: 'PROXY_SSLKEY_BLOB',
    /**
     * Proxy client key type.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEYTYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLKEYTYPE.html)
     */
    proxySslKeyType: 'PROXY_SSLKEYTYPE',
    /**
     * Proxy SSL version to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLVERSION.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_SSLVERSION.html)
     */
    proxySslversion: 'PROXY_SSLVERSION',
    /**
     * Proxy TLS 1.3 cipher suites to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLS13_CIPHERS.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLS13_CIPHERS.html)
     */
    proxyTls13Ciphers: 'PROXY_TLS13_CIPHERS',
    /**
     * Proxy TLS authentication password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_PASSWORD.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_PASSWORD.html)
     */
    proxyTlsAuthPassword: 'PROXY_TLSAUTH_PASSWORD',
    /**
     * Proxy TLS authentication methods.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_TYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_TYPE.html)
     */
    proxyTlsAuthType: 'PROXY_TLSAUTH_TYPE',
    /**
     * Proxy TLS authentication user name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_USERNAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TLSAUTH_USERNAME.html)
     */
    proxyTlsAuthUsername: 'PROXY_TLSAUTH_USERNAME',
    /**
     * Add transfer mode to URL over proxy.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TRANSFER_MODE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXY_TRANSFER_MODE.html)
     */
    proxyTransferMode: 'PROXY_TRANSFER_MODE',
    /**
     * HTTP proxy authentication methods.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYAUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYAUTH.html)
     */
    proxyAuth: 'PROXYAUTH',
    /**
     * Custom HTTP headers sent to proxy.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYHEADER.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYHEADER.html)
     */
    proxyHeader: 'PROXYHEADER',
    /**
     * Proxy password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYPASSWORD.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYPASSWORD.html)
     */
    proxyPassword: 'PROXYPASSWORD',
    /**
     * Proxy port to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYPORT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYPORT.html)
     */
    proxyPort: 'PROXYPORT',
    /**
     * Proxy type.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYTYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYTYPE.html)
     */
    proxyType: 'PROXYTYPE',
    /**
     * Proxy user name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYUSERNAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYUSERNAME.html)
     */
    proxyUsername: 'PROXYUSERNAME',
    /**
     * Proxy user name and password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PROXYUSERPWD.html](https://curl.haxx.se/libcurl/c/CURLOPT_PROXYUSERPWD.html)
     */
    proxyUserpwd: 'PROXYUSERPWD',
    /**
     * Issue an HTTP PUT request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_PUT.html](https://curl.haxx.se/libcurl/c/CURLOPT_PUT.html)
     */
    put: 'PUT',
    /**
     * Commands to run before transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_QUOTE.html](https://curl.haxx.se/libcurl/c/CURLOPT_QUOTE.html)
     */
    quote: 'QUOTE',
    /**
     * Provide source for entropy random data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RANDOM_FILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_RANDOM_FILE.html)
     */
    randomFile: 'RANDOM_FILE',
    /**
     * Range requests.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RANGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_RANGE.html)
     */
    range: 'RANGE',
    /**
     * Data pointer to pass to the read callback.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_READDATA.html](https://curl.haxx.se/libcurl/c/CURLOPT_READDATA.html)
     */
    readData: 'READDATA',
    /**
     * Callback for reading data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_READFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_READFUNCTION.html)
     */
    readFunction: 'READFUNCTION',
    /**
     * Protocols to allow redirects to.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_REDIR_PROTOCOLS.html](https://curl.haxx.se/libcurl/c/CURLOPT_REDIR_PROTOCOLS.html)
     */
    redirProtocols: 'REDIR_PROTOCOLS',
    /**
     * Referer: header.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_REFERER.html](https://curl.haxx.se/libcurl/c/CURLOPT_REFERER.html)
     */
    referer: 'REFERER',
    /**
     * Set the request target.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_REQUEST_TARGET.html](https://curl.haxx.se/libcurl/c/CURLOPT_REQUEST_TARGET.html)
     */
    requestTarget: 'REQUEST_TARGET',
    /**
     * Provide fixed/fake name resolves.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RESOLVE.html](https://curl.haxx.se/libcurl/c/CURLOPT_RESOLVE.html)
     */
    resolve: 'RESOLVE',
    /**
     * Resume a transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RESUME_FROM.html](https://curl.haxx.se/libcurl/c/CURLOPT_RESUME_FROM.html)
     */
    resumeFrom: 'RESUME_FROM',
    /**
     * Resume a transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RESUME_FROM_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_RESUME_FROM_LARGE.html)
     */
    resumeFromLarge: 'RESUME_FROM_LARGE',
    /**
     * Client CSEQ number.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_CLIENT_CSEQ.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_CLIENT_CSEQ.html)
     */
    rtspClientCseq: 'RTSP_CLIENT_CSEQ',
    /**
     * RTSP request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_REQUEST.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_REQUEST.html)
     */
    rtspRequest: 'RTSP_REQUEST',
    /**
     * CSEQ number for RTSP Server-\>Client request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_SERVER_CSEQ.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_SERVER_CSEQ.html)
     */
    rtspServerCseq: 'RTSP_SERVER_CSEQ',
    /**
     * RTSP session-id.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_SESSION_ID.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_SESSION_ID.html)
     */
    rtspSessionId: 'RTSP_SESSION_ID',
    /**
     * RTSP stream URI.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_STREAM_URI.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_STREAM_URI.html)
     */
    rtspStreamUri: 'RTSP_STREAM_URI',
    /**
     * RTSP Transport: header.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_TRANSPORT.html](https://curl.haxx.se/libcurl/c/CURLOPT_RTSP_TRANSPORT.html)
     */
    rtspTransPort: 'RTSP_TRANSPORT',
    /**
     * SASL authorisation identity (identity to act as).
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SASL_AUTHZID.html](https://curl.haxx.se/libcurl/c/CURLOPT_SASL_AUTHZID.html)
     */
    saslAuthzId: 'SASL_AUTHZID',
    /**
     * Enable SASL initial response.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SASL_IR.html](https://curl.haxx.se/libcurl/c/CURLOPT_SASL_IR.html)
     */
    saslIr: 'SASL_IR',
    /**
     * Callback for seek operations.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SEEKFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_SEEKFUNCTION.html)
     */
    seekFunction: 'SEEKFUNCTION',
    /**
     * Authentication service name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SERVICE_NAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_SERVICE_NAME.html)
     */
    serviceName: 'SERVICE_NAME',
    /**
     * Share object to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SHARE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SHARE.html)
     */
    share: 'SHARE',
    /**
     * Socks5 authentication methods.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_AUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_AUTH.html)
     */
    socks5Auth: 'SOCKS5_AUTH',
    /**
     * Socks5 GSSAPI NEC mode.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_GSSAPI_NEC.html](https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_GSSAPI_NEC.html)
     */
    socks5GssapiNec: 'SOCKS5_GSSAPI_NEC',
    /**
     * Socks5 GSSAPI service name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_GSSAPI_SERVICE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SOCKS5_GSSAPI_SERVICE.html)
     */
    socks5GssapiService: 'SOCKS5_GSSAPI_SERVICE',
    /**
     * SSH authentication types.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_AUTH_TYPES.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_AUTH_TYPES.html)
     */
    sshAuthTypes: 'SSH_AUTH_TYPES',
    /**
     * Enable SSH compression.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_COMPRESSION.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_COMPRESSION.html)
     */
    sshCompression: 'SSH_COMPRESSION',
    /**
     * MD5 of host's public key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_HOST_PUBLIC_KEY_MD5.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_HOST_PUBLIC_KEY_MD5.html)
     */
    sshHostPublicKeyMd5: 'SSH_HOST_PUBLIC_KEY_MD5',
    /**
     * File name with known hosts.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_KNOWNHOSTS.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_KNOWNHOSTS.html)
     */
    sshKnownHosts: 'SSH_KNOWNHOSTS',
    /**
     * File name of private key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_PRIVATE_KEYFILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_PRIVATE_KEYFILE.html)
     */
    sshPrivateKeyFile: 'SSH_PRIVATE_KEYFILE',
    /**
     * File name of public key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSH_PUBLIC_KEYFILE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSH_PUBLIC_KEYFILE.html)
     */
    sshPublicKeyFile: 'SSH_PUBLIC_KEYFILE',
    /**
     * Ciphers to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_CIPHER_LIST.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_CIPHER_LIST.html)
     */
    sslCipherList: 'SSL_CIPHER_LIST',
    /**
     * Set key exchange curves.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_EC_CURVES.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_EC_CURVES.html)
     */
    sslEcCurves: 'SSL_EC_CURVES',
    /**
     * Enable use of ALPN.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_ENABLE_ALPN.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_ENABLE_ALPN.html)
     */
    sslEnableAlpn: 'SSL_ENABLE_ALPN',
    /**
     * Enable use of NPN.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_ENABLE_NPN.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_ENABLE_NPN.html)
     */
    sslEnableNpn: 'SSL_ENABLE_NPN',
    /**
     * Enable TLS False Start.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_FALSESTART.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_FALSESTART.html)
     */
    sslFalsestart: 'SSL_FALSESTART',
    /**
     * Control SSL behavior.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_OPTIONS.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_OPTIONS.html)
     */
    sslOptions: 'SSL_OPTIONS',
    /**
     * Disable SSL session-id cache.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_SESSIONID_CACHE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_SESSIONID_CACHE.html)
     */
    sslSessionIdCache: 'SSL_SESSIONID_CACHE',
    /**
     * Verify the host name in the SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYHOST.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYHOST.html)
     */
    sslVerifyHost: 'SSL_VERIFYHOST',
    /**
     * Verify the SSL certificate.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html)
     */
    sslVerifyPeer: 'SSL_VERIFYPEER',
    /**
     * Verify the SSL certificate's status.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYSTATUS.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYSTATUS.html)
     */
    sslVerifyStatus: 'SSL_VERIFYSTATUS',
    /**
     * Client cert.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERT.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERT.html)
     */
    sslCert: 'SSLCERT',
    /**
     * Client cert memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERT_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERT_BLOB.html)
     */
    sslCertBlob: 'SSLCERT_BLOB',
    /**
     * Client cert type.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERTTYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLCERTTYPE.html)
     */
    sslCertType: 'SSLCERTTYPE',
    /**
     * Use identifier with SSL engine.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLENGINE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLENGINE.html)
     */
    sslEngine: 'SSLENGINE',
    /**
     * Default SSL engine.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLENGINE_DEFAULT.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLENGINE_DEFAULT.html)
     */
    sslEngineDefault: 'SSLENGINE_DEFAULT',
    /**
     * Client key.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEY.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEY.html)
     */
    sslKey: 'SSLKEY',
    /**
     * Client key memory buffer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEY_BLOB.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEY_BLOB.html)
     */
    sslKeyBlob: 'SSLKEY_BLOB',
    /**
     * Client key type.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEYTYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLKEYTYPE.html)
     */
    sslKeyType: 'SSLKEYTYPE',
    /**
     * SSL version to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SSLVERSION.html](https://curl.haxx.se/libcurl/c/CURLOPT_SSLVERSION.html)
     */
    sslversion: 'SSLVERSION',
    /**
     * Suppress proxy CONNECT response headers from user callbacks.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_SUPPRESS_CONNECT_HEADERS.html](https://curl.haxx.se/libcurl/c/CURLOPT_SUPPRESS_CONNECT_HEADERS.html)
     */
    suppressConnectHeaders: 'SUPPRESS_CONNECT_HEADERS',
    /**
     * Enable TFO, TCP Fast Open.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TCP_FASTOPEN.html](https://curl.haxx.se/libcurl/c/CURLOPT_TCP_FASTOPEN.html)
     */
    tcpFastOpen: 'TCP_FASTOPEN',
    /**
     * Enable TCP keep-alive.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPALIVE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPALIVE.html)
     */
    tcpKeepAlive: 'TCP_KEEPALIVE',
    /**
     * Idle time before sending keep-alive.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPIDLE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPIDLE.html)
     */
    tcpKeepIdle: 'TCP_KEEPIDLE',
    /**
     * Interval between keep-alive probes.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPINTVL.html](https://curl.haxx.se/libcurl/c/CURLOPT_TCP_KEEPINTVL.html)
     */
    tcpKeepIntvl: 'TCP_KEEPINTVL',
    /**
     * Disable the Nagle algorithm.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TCP_NODELAY.html](https://curl.haxx.se/libcurl/c/CURLOPT_TCP_NODELAY.html)
     */
    tcpNoDelay: 'TCP_NODELAY',
    /**
     * TELNET options.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TELNETOPTIONS.html](https://curl.haxx.se/libcurl/c/CURLOPT_TELNETOPTIONS.html)
     */
    telnetOptions: 'TELNETOPTIONS',
    /**
     * TFTP block size.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TFTP_BLKSIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TFTP_BLKSIZE.html)
     */
    tftpBlkSize: 'TFTP_BLKSIZE',
    /**
     * Do not send TFTP options requests.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TFTP_NO_OPTIONS.html](https://curl.haxx.se/libcurl/c/CURLOPT_TFTP_NO_OPTIONS.html)
     */
    tftpNoOptions: 'TFTP_NO_OPTIONS',
    /**
     * Make a time conditional request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TIMECONDITION.html](https://curl.haxx.se/libcurl/c/CURLOPT_TIMECONDITION.html)
     */
    timeCondition: 'TIMECONDITION',
    /**
     * Timeout for the entire request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT.html](https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT.html)
     */
    timeout: 'TIMEOUT',
    /**
     * Millisecond timeout for the entire request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_TIMEOUT_MS.html)
     */
    timeoutMs: 'TIMEOUT_MS',
    /**
     * Time value for the time conditional request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TIMEVALUE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TIMEVALUE.html)
     */
    timeValue: 'TIMEVALUE',
    /**
     * Time value for the time conditional request.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TIMEVALUE_LARGE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TIMEVALUE_LARGE.html)
     */
    timeValueLarge: 'TIMEVALUE_LARGE',
    /**
     * TLS 1.3 cipher suites to use.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TLS13_CIPHERS.html](https://curl.haxx.se/libcurl/c/CURLOPT_TLS13_CIPHERS.html)
     */
    tls13Ciphers: 'TLS13_CIPHERS',
    /**
     * TLS authentication password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_PASSWORD.html](https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_PASSWORD.html)
     */
    tlsAuthPassword: 'TLSAUTH_PASSWORD',
    /**
     * TLS authentication methods.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_TYPE.html](https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_TYPE.html)
     */
    tlsAuthType: 'TLSAUTH_TYPE',
    /**
     * TLS authentication user name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_USERNAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_TLSAUTH_USERNAME.html)
     */
    tlsAuthUsername: 'TLSAUTH_USERNAME',
    /**
     * Set callback for sending trailing headers.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TRAILERFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_TRAILERFUNCTION.html)
     */
    trailerFunction: 'TRAILERFUNCTION',
    /**
     * Request Transfer-Encoding.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TRANSFER_ENCODING.html](https://curl.haxx.se/libcurl/c/CURLOPT_TRANSFER_ENCODING.html)
     */
    transferEncoding: 'TRANSFER_ENCODING',
    /**
     * Use text transfer.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_TRANSFERTEXT.html](https://curl.haxx.se/libcurl/c/CURLOPT_TRANSFERTEXT.html)
     */
    transferText: 'TRANSFERTEXT',
    /**
     * Path to a Unix domain socket.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_UNIX_SOCKET_PATH.html](https://curl.haxx.se/libcurl/c/CURLOPT_UNIX_SOCKET_PATH.html)
     */
    unixSocketPath: 'UNIX_SOCKET_PATH',
    /**
     * Do not restrict authentication to original host.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_UNRESTRICTED_AUTH.html](https://curl.haxx.se/libcurl/c/CURLOPT_UNRESTRICTED_AUTH.html)
     */
    unrestrictedAuth: 'UNRESTRICTED_AUTH',
    /**
     * Sets the interval at which connection upkeep are performed.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_UPKEEP_INTERVAL_MS.html](https://curl.haxx.se/libcurl/c/CURLOPT_UPKEEP_INTERVAL_MS.html)
     */
    upkeepIntervalMs: 'UPKEEP_INTERVAL_MS',
    /**
     * Upload data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_UPLOAD.html](https://curl.haxx.se/libcurl/c/CURLOPT_UPLOAD.html)
     */
    upload: 'UPLOAD',
    /**
     * Set upload buffer size.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_UPLOAD_BUFFERSIZE.html](https://curl.haxx.se/libcurl/c/CURLOPT_UPLOAD_BUFFERSIZE.html)
     */
    uploadBufferSize: 'UPLOAD_BUFFERSIZE',
    /**
     * URL to work on.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_URL.html](https://curl.haxx.se/libcurl/c/CURLOPT_URL.html)
     */
    url: 'URL',
    /**
     * Use TLS/SSL.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_USE_SSL.html](https://curl.haxx.se/libcurl/c/CURLOPT_USE_SSL.html)
     */
    useSsl: 'USE_SSL',
    /**
     * User-Agent: header.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_USERAGENT.html](https://curl.haxx.se/libcurl/c/CURLOPT_USERAGENT.html)
     */
    userAgent: 'USERAGENT',
    /**
     * User name.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_USERNAME.html](https://curl.haxx.se/libcurl/c/CURLOPT_USERNAME.html)
     */
    username: 'USERNAME',
    /**
     * User name and password.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_USERPWD.html](https://curl.haxx.se/libcurl/c/CURLOPT_USERPWD.html)
     */
    userpwd: 'USERPWD',
    /**
     * Display verbose information.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_VERBOSE.html](https://curl.haxx.se/libcurl/c/CURLOPT_VERBOSE.html)
     */
    verbose: 'VERBOSE',
    /**
     * Transfer multiple files according to a file name pattern.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_WILDCARDMATCH.html](https://curl.haxx.se/libcurl/c/CURLOPT_WILDCARDMATCH.html)
     */
    wildcardMatch: 'WILDCARDMATCH',
    /**
     * Callback for writing data.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_WRITEFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_WRITEFUNCTION.html)
     */
    writeFunction: 'WRITEFUNCTION',
    /**
     * Callback for progress meter.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_XFERINFOFUNCTION.html](https://curl.haxx.se/libcurl/c/CURLOPT_XFERINFOFUNCTION.html)
     */
    xferInfoFunction: 'XFERINFOFUNCTION',
    /**
     * OAuth2 bearer token.
     *
     * Official libcurl documentation: : [https://curl.haxx.se/libcurl/c/CURLOPT_XOAUTH2_BEARER.html](https://curl.haxx.se/libcurl/c/CURLOPT_XOAUTH2_BEARER.html)
     */
    xoauth2Bearer: 'XOAUTH2_BEARER',
};
//# sourceMappingURL=CurlOption.js.map