/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Doug Lea with assistance from members of JCP JSR-166
 * Expert Group and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 */


package java.util.concurrent.atomic;


/**
 * An {@code AtomicStampedReference} maintains an object reference
 * along with an integer "stamp", that can be updated atomically.
 *
 * <p>Implementation note: This implementation maintains stamped
 * references by creating internal objects representing "boxed"
 * [reference, integer] pairs.
 *
 * @since 1.5
 * @author Doug Lea
 * @param <V> The type of object referred to by this reference
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AtomicStampedReference<V> {

/**
 * Creates a new {@code AtomicStampedReference} with the given
 * initial values.
 *
 * @param initialRef the initial reference
 * @param initialStamp the initial stamp
 */

public AtomicStampedReference(V initialRef, int initialStamp) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the value of the stamp to the given update value
 * if the current reference is {@code ==} to the expected
 * reference.  Any given invocation of this operation may fail
 * (return {@code false}) spuriously, but repeated invocation
 * when the current value holds the expected value and no other
 * thread is also attempting to set the value will eventually
 * succeed.
 *
 * @param expectedReference the expected value of the reference
 * @param newStamp the new value for the stamp
 * @return {@code true} if successful
 */

public boolean attemptStamp(V expectedReference, int newStamp) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the value of both the reference and stamp
 * to the given update values if the
 * current reference is {@code ==} to the expected reference
 * and the current stamp is equal to the expected stamp.
 *
 * @param expectedReference the expected value of the reference
 * @param newReference the new value for the reference
 * @param expectedStamp the expected value of the stamp
 * @param newStamp the new value for the stamp
 * @return {@code true} if successful
 */

public boolean compareAndSet(V expectedReference, V newReference, int expectedStamp, int newStamp) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current values of both the reference and the stamp.
 * Typical usage is {@code int[1] holder; ref = v.get(holder); }.
 *
 * @param stampHolder an array of size of at least one.  On return,
 * {@code stampHolder[0]} will hold the value of the stamp.
 * @return the current value of the reference
 */

public V get(int[] stampHolder) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the reference.
 *
 * @return the current value of the reference
 */

public V getReference() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the stamp.
 *
 * @return the current value of the stamp
 */

public int getStamp() { throw new RuntimeException("Stub!"); }

/**
 * Unconditionally sets the value of both the reference and stamp.
 *
 * @param newReference the new value for the reference
 * @param newStamp the new value for the stamp
 */

public void set(V newReference, int newStamp) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the value of both the reference and stamp to
 * the given update values if the current reference is {@code ==}
 * to the expected reference and the current stamp is equal to the
 * expected stamp. This operation may fail spuriously and does not
 * provide ordering guarantees, so is only rarely an
 * appropriate alternative to {@code compareAndSet}.
 *
 * @param expectedReference the expected value of the reference
 * @param newReference the new value for the reference
 * @param expectedStamp the expected value of the stamp
 * @param newStamp the new value for the stamp
 * @return {@code true} if successful
 */

public boolean weakCompareAndSet(V expectedReference, V newReference, int expectedStamp, int newStamp) { throw new RuntimeException("Stub!"); }
}

