/*
 * Copyright (c) 2013, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.util;


/**
 * A generator of uniform pseudorandom values (with period 2<sup>64</sup>)
 * applicable for use in (among other contexts) isolated parallel
 * computations that may generate subtasks. Class {@code SplittableRandom}
 * supports methods for producing pseudorandom numbers of type {@code int},
 * {@code long}, and {@code double} with similar usages as for class
 * {@link java.util.Random} but differs in the following ways:
 *
 * <ul>
 *
 * <li>Series of generated values pass the DieHarder suite testing
 * independence and uniformity properties of random number generators.
 * (Most recently validated with <a
 * href="http://www.phy.duke.edu/~rgb/General/dieharder.php"> version
 * 3.31.1</a>.) These tests validate only the methods for certain
 * types and ranges, but similar properties are expected to hold, at
 * least approximately, for others as well. The <em>period</em>
 * (length of any series of generated values before it repeats) is
 * 2<sup>64</sup>. </li>
 *
 * <li> Method {@link #split} constructs and returns a new
 * SplittableRandom instance that shares no mutable state with the
 * current instance. However, with very high probability, the
 * values collectively generated by the two objects have the same
 * statistical properties as if the same quantity of values were
 * generated by a single thread using a single {@code
 * SplittableRandom} object.  </li>
 *
 * <li>Instances of SplittableRandom are <em>not</em> thread-safe.
 * They are designed to be split, not shared, across threads. For
 * example, a {@link java.util.concurrent.ForkJoinTask
 * fork/join-style} computation using random numbers might include a
 * construction of the form {@code new
 * Subtask(aSplittableRandom.split()).fork()}.
 *
 * <li>This class provides additional methods for generating random
 * streams, that employ the above techniques when used in {@code
 * stream.parallel()} mode.</li>
 *
 * </ul>
 *
 * <p>Instances of {@code SplittableRandom} are not cryptographically
 * secure.  Consider instead using {@link java.security.SecureRandom}
 * in security-sensitive applications. Additionally,
 * default-constructed instances do not use a cryptographically random
 * seed unless the {@linkplain java.lang.System#getProperty system property}
 * {@code java.util.secureRandomSeed} is set to {@code true}.
 *
 * @author  Guy Steele
 * @author  Doug Lea
 * @since   1.8
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SplittableRandom implements java.util.random.RandomGenerator, java.util.random.RandomGenerator.SplittableGenerator {

/**
 * Creates a new SplittableRandom instance that is likely to
 * generate sequences of values that are statistically independent
 * of those of any other instances in the current program; and
 * may, and typically does, vary across program invocations.
 */

public SplittableRandom() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new SplittableRandom instance using the specified
 * initial seed. SplittableRandom instances created with the same
 * seed in the same program generate identical sequences of values.
 *
 * @param seed the initial seed
 */

public SplittableRandom(long seed) { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code
 * double} values from this generator and/or one split from it; each value
 * is between zero (inclusive) and one (exclusive).
 *
 * @implNote This method is implemented to be equivalent to {@code
 * doubles(Long.MAX_VALUE)}.
 *
 * @return a stream of pseudorandom {@code double} values
 */

public java.util.stream.DoubleStream doubles() { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code
 * double} values from this generator and/or one split from it; each value
 * conforms to the given origin (inclusive) and bound (exclusive).
 *
 * @implNote This method is implemented to be equivalent to {@code
 * doubles(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 *
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code double} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number of
 * pseudorandom {@code double} values from this generator and/or one split
 * from it; each value is between zero (inclusive) and one (exclusive).
 *
 * @param streamSize the number of values to generate
 * @return a stream of {@code double} values
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero
 */

public java.util.stream.DoubleStream doubles(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number of
 * pseudorandom {@code double} values from this generator and/or one split
 * from it; each value conforms to the given origin (inclusive) and bound
 * (exclusive).
 *
 * @param streamSize the number of values to generate
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code double} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero, or {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code int}
 * values from this generator and/or one split from it.
 *
 * @implNote This method is implemented to be equivalent to {@code
 * ints(Long.MAX_VALUE)}.
 *
 * @return a stream of pseudorandom {@code int} values
 */

public java.util.stream.IntStream ints() { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code
 * int} values from this generator and/or one split from it; each value
 * conforms to the given origin (inclusive) and bound (exclusive).
 *
 * @implNote This method is implemented to be equivalent to {@code
 * ints(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 *
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code int} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.IntStream ints(int randomNumberOrigin, int randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number
 * of pseudorandom {@code int} values from this generator and/or
 * one split from it.
 *
 * @param streamSize the number of values to generate
 * @return a stream of pseudorandom {@code int} values
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero
 */

public java.util.stream.IntStream ints(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number
 * of pseudorandom {@code int} values from this generator and/or one split
 * from it; each value conforms to the given origin (inclusive) and bound
 * (exclusive).
 *
 * @param streamSize the number of values to generate
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code int} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero, or {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code
 * long} values from this generator and/or one split from it.
 *
 * @implNote This method is implemented to be equivalent to {@code
 * longs(Long.MAX_VALUE)}.
 *
 * @return a stream of pseudorandom {@code long} values
 */

public java.util.stream.LongStream longs() { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number
 * of pseudorandom {@code long} values from this generator and/or
 * one split from it.
 *
 * @param streamSize the number of values to generate
 * @return a stream of pseudorandom {@code long} values
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero
 */

public java.util.stream.LongStream longs(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * Returns an effectively unlimited stream of pseudorandom {@code
 * long} values from this generator and/or one split from it; each value
 * conforms to the given origin (inclusive) and bound (exclusive).
 *
 * @implNote This method is implemented to be equivalent to {@code
 * longs(Long.MAX_VALUE, randomNumberOrigin, randomNumberBound)}.
 *
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code long} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.LongStream longs(long randomNumberOrigin, long randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * Returns a stream producing the given {@code streamSize} number of
 * pseudorandom {@code long} values from this generator and/or one split
 * from it; each value conforms to the given origin (inclusive) and bound
 * (exclusive).
 *
 * @param streamSize the number of values to generate
 * @param randomNumberOrigin the origin (inclusive) of each random value
 * @param randomNumberBound the bound (exclusive) of each random value
 * @return a stream of pseudorandom {@code long} values,
 *         each with the given origin (inclusive) and bound (exclusive)
 * @throws java.lang.IllegalArgumentException if {@code streamSize} is
 *         less than zero, or {@code randomNumberOrigin}
 *         is greater than or equal to {@code randomNumberBound}
 */

public java.util.stream.LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 * @since 10
 */

public void nextBytes(byte[] bytes) { throw new RuntimeException("Stub!"); }

public int nextInt() { throw new RuntimeException("Stub!"); }

public long nextLong() { throw new RuntimeException("Stub!"); }

/**
 * Constructs and returns a new SplittableRandom instance that
 * shares no mutable state with this instance. However, with very
 * high probability, the set of values collectively generated by
 * the two objects has the same statistical properties as if the
 * same quantity of values were generated by a single thread using
 * a single SplittableRandom object.  Either or both of the two
 * objects may be further split using the {@code split()} method,
 * and the same expected statistical properties apply to the
 * entire set of generators constructed by such recursive
 * splitting.
 *
 * @return the new SplittableRandom instance
 */

public java.util.SplittableRandom split() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 * @since 17
 */

public java.util.SplittableRandom split(java.util.random.RandomGenerator.SplittableGenerator source) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @implSpec {@inheritDoc}
 * @since 17
 */

public java.util.stream.Stream<java.util.random.RandomGenerator.SplittableGenerator> splits() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 * @implSpec {@inheritDoc}
 * @since 17
 */

public java.util.stream.Stream<java.util.random.RandomGenerator.SplittableGenerator> splits(java.util.random.RandomGenerator.SplittableGenerator source) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implSpec {@inheritDoc}
 * @since 17
 */

public java.util.stream.Stream<java.util.random.RandomGenerator.SplittableGenerator> splits(long streamSize) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 * @implSpec {@inheritDoc}
 * @since 17
 */

public java.util.stream.Stream<java.util.random.RandomGenerator.SplittableGenerator> splits(long streamSize, java.util.random.RandomGenerator.SplittableGenerator source) { throw new RuntimeException("Stub!"); }
}

