/*
 * Copyright 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.textclassifier;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TextLinks implements android.os.Parcelable {

TextLinks() { throw new RuntimeException("Stub!"); }

public int apply(@android.annotation.NonNull android.text.Spannable text, int applyStrategy, @android.annotation.Nullable java.util.function.Function<android.view.textclassifier.TextLinks.TextLink,android.view.textclassifier.TextLinks.TextLinkSpan> spanFactory) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Collection<android.view.textclassifier.TextLinks.TextLink> getLinks() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getText() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int APPLY_STRATEGY_IGNORE = 0; // 0x0

public static final int APPLY_STRATEGY_REPLACE = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextLinks> CREATOR;
static { CREATOR = null; }

public static final int STATUS_DIFFERENT_TEXT = 3; // 0x3

public static final int STATUS_LINKS_APPLIED = 0; // 0x0

public static final int STATUS_NO_LINKS_APPLIED = 2; // 0x2

public static final int STATUS_NO_LINKS_FOUND = 1; // 0x1

public static final int STATUS_UNSUPPORTED_CHARACTER = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.String fullText) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Builder addLink(int start, int end, @android.annotation.NonNull java.util.Map<java.lang.String,java.lang.Float> entityScores) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Builder addLink(int start, int end, @android.annotation.NonNull java.util.Map<java.lang.String,java.lang.Float> entityScores, @android.annotation.NonNull android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Builder clearTextLinks() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Builder setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Request implements android.os.Parcelable {

Request() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getCallingPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.LocaleList getDefaultLocales() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.view.textclassifier.TextClassifier.EntityConfig getEntityConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.time.ZonedDateTime getReferenceTime() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getText() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextLinks.Request> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.CharSequence text) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Request build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Request.Builder setDefaultLocales(@android.annotation.Nullable android.os.LocaleList defaultLocales) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Request.Builder setEntityConfig(@android.annotation.Nullable android.view.textclassifier.TextClassifier.EntityConfig entityConfig) { throw new RuntimeException("Stub!"); }

public android.view.textclassifier.TextLinks.Request.Builder setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextLinks.Request.Builder setReferenceTime(@android.annotation.Nullable java.time.ZonedDateTime referenceTime) { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TextLink implements android.os.Parcelable {

TextLink() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public float getConfidenceScore(java.lang.String entityType) { throw new RuntimeException("Stub!"); }

public int getEnd() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getEntity(int index) { throw new RuntimeException("Stub!"); }

public int getEntityCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public int getStart() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextLinks.TextLink> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class TextLinkSpan extends android.text.style.ClickableSpan {

public TextLinkSpan(@android.annotation.NonNull android.view.textclassifier.TextLinks.TextLink textLink) { throw new RuntimeException("Stub!"); }

public final android.view.textclassifier.TextLinks.TextLink getTextLink() { throw new RuntimeException("Stub!"); }

public void onClick(android.view.View widget) { throw new RuntimeException("Stub!"); }
}

}

