/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ViewParent {

public void bringChildToFront(android.view.View child);

public boolean canResolveLayoutDirection();

public boolean canResolveTextAlignment();

public boolean canResolveTextDirection();

public void childDrawableStateChanged(@android.annotation.NonNull android.view.View child);

public void childHasTransientStateChanged(@android.annotation.NonNull android.view.View child, boolean hasTransientState);

public void clearChildFocus(android.view.View child);

public void createContextMenu(android.view.ContextMenu menu);

@android.annotation.Nullable
public default android.window.OnBackInvokedDispatcher findOnBackInvokedDispatcherForChild(@android.annotation.NonNull android.view.View child, @android.annotation.NonNull android.view.View requester) { throw new RuntimeException("Stub!"); }

public android.view.View focusSearch(android.view.View v, int direction);

public void focusableViewAvailable(android.view.View v);

public boolean getChildVisibleRect(android.view.View child, android.graphics.Rect r, android.graphics.Point offset);

public int getLayoutDirection();

public android.view.ViewParent getParent();

public android.view.ViewParent getParentForAccessibility();

public int getTextAlignment();

public int getTextDirection();

@Deprecated
public void invalidateChild(android.view.View child, android.graphics.Rect r);

@Deprecated
public android.view.ViewParent invalidateChildInParent(int[] location, android.graphics.Rect r);

public boolean isLayoutDirectionResolved();

public boolean isLayoutRequested();

public boolean isTextAlignmentResolved();

public boolean isTextDirectionResolved();

public android.view.View keyboardNavigationClusterSearch(android.view.View currentCluster, int direction);

public void notifySubtreeAccessibilityStateChanged(@android.annotation.NonNull android.view.View child, @android.annotation.NonNull android.view.View source, int changeType);

public default void onDescendantInvalidated(@android.annotation.NonNull android.view.View child, @android.annotation.NonNull android.view.View target) { throw new RuntimeException("Stub!"); }

public boolean onNestedFling(@android.annotation.NonNull android.view.View target, float velocityX, float velocityY, boolean consumed);

public boolean onNestedPreFling(@android.annotation.NonNull android.view.View target, float velocityX, float velocityY);

public boolean onNestedPrePerformAccessibilityAction(@android.annotation.NonNull android.view.View target, int action, @android.annotation.Nullable android.os.Bundle arguments);

public void onNestedPreScroll(@android.annotation.NonNull android.view.View target, int dx, int dy, @android.annotation.NonNull int[] consumed);

public void onNestedScroll(@android.annotation.NonNull android.view.View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed);

public void onNestedScrollAccepted(@android.annotation.NonNull android.view.View child, @android.annotation.NonNull android.view.View target, int nestedScrollAxes);

public boolean onStartNestedScroll(@android.annotation.NonNull android.view.View child, @android.annotation.NonNull android.view.View target, int nestedScrollAxes);

public void onStopNestedScroll(@android.annotation.NonNull android.view.View target);

public void recomputeViewAttributes(android.view.View child);

public void requestChildFocus(android.view.View child, android.view.View focused);

public boolean requestChildRectangleOnScreen(@android.annotation.NonNull android.view.View child, android.graphics.Rect rectangle, boolean immediate);

public void requestDisallowInterceptTouchEvent(boolean disallowIntercept);

public void requestFitSystemWindows();

public void requestLayout();

public boolean requestSendAccessibilityEvent(@android.annotation.NonNull android.view.View child, android.view.accessibility.AccessibilityEvent event);

public void requestTransparentRegion(android.view.View child);

public boolean showContextMenuForChild(android.view.View originalView);

public boolean showContextMenuForChild(android.view.View originalView, float x, float y);

public android.view.ActionMode startActionModeForChild(android.view.View originalView, android.view.ActionMode.Callback callback);

public android.view.ActionMode startActionModeForChild(android.view.View originalView, android.view.ActionMode.Callback callback, int type);
}

