/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony.ims;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ImsStateCallback {

public ImsStateCallback() { throw new RuntimeException("Stub!"); }

public abstract void onAvailable();

public abstract void onError();

public abstract void onUnavailable(int reason);

public static final int REASON_IMS_SERVICE_DISCONNECTED = 3; // 0x3

public static final int REASON_IMS_SERVICE_NOT_READY = 6; // 0x6

public static final int REASON_NO_IMS_SERVICE_CONFIGURED = 4; // 0x4

public static final int REASON_SUBSCRIPTION_INACTIVE = 5; // 0x5

public static final int REASON_UNKNOWN_PERMANENT_ERROR = 2; // 0x2

public static final int REASON_UNKNOWN_TEMPORARY_ERROR = 1; // 0x1
}

