/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.service.carrier;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CarrierMessagingService extends android.app.Service {

public CarrierMessagingService() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.IBinder onBind(@android.annotation.NonNull android.content.Intent intent) { throw new RuntimeException("Stub!"); }

public void onDownloadMms(@android.annotation.NonNull android.net.Uri contentUri, int subId, @android.annotation.NonNull android.net.Uri location, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onFilterSms(@android.annotation.NonNull android.service.carrier.MessagePdu pdu, @android.annotation.NonNull java.lang.String format, int destPort, int subId, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public void onReceiveTextSms(@android.annotation.NonNull android.service.carrier.MessagePdu pdu, @android.annotation.NonNull java.lang.String format, int destPort, int subId, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onSendDataSms(@android.annotation.NonNull byte[] data, int subId, @android.annotation.NonNull java.lang.String destAddress, int destPort, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendSmsResult> callback) { throw new RuntimeException("Stub!"); }

public void onSendDataSms(@android.annotation.NonNull byte[] data, int subId, @android.annotation.NonNull java.lang.String destAddress, int destPort, int sendSmsFlag, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendSmsResult> callback) { throw new RuntimeException("Stub!"); }

public void onSendMms(@android.annotation.NonNull android.net.Uri pduUri, int subId, @android.annotation.Nullable android.net.Uri location, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendMmsResult> callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onSendMultipartTextSms(@android.annotation.NonNull java.util.List<java.lang.String> parts, int subId, @android.annotation.NonNull java.lang.String destAddress, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendMultipartSmsResult> callback) { throw new RuntimeException("Stub!"); }

public void onSendMultipartTextSms(@android.annotation.NonNull java.util.List<java.lang.String> parts, int subId, @android.annotation.NonNull java.lang.String destAddress, int sendSmsFlag, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendMultipartSmsResult> callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onSendTextSms(@android.annotation.NonNull java.lang.String text, int subId, @android.annotation.NonNull java.lang.String destAddress, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendSmsResult> callback) { throw new RuntimeException("Stub!"); }

public void onSendTextSms(@android.annotation.NonNull java.lang.String text, int subId, @android.annotation.NonNull java.lang.String destAddress, int sendSmsFlag, @android.annotation.NonNull android.service.carrier.CarrierMessagingService.ResultCallback<android.service.carrier.CarrierMessagingService.SendSmsResult> callback) { throw new RuntimeException("Stub!"); }

public static final int DOWNLOAD_STATUS_ERROR = 2; // 0x2

public static final int DOWNLOAD_STATUS_MMS_ERROR_CONFIGURATION_ERROR = 606; // 0x25e

public static final int DOWNLOAD_STATUS_MMS_ERROR_DATA_DISABLED = 610; // 0x262

public static final int DOWNLOAD_STATUS_MMS_ERROR_HTTP_FAILURE = 603; // 0x25b

public static final int DOWNLOAD_STATUS_MMS_ERROR_INACTIVE_SUBSCRIPTION = 609; // 0x261

public static final int DOWNLOAD_STATUS_MMS_ERROR_INVALID_APN = 601; // 0x259

public static final int DOWNLOAD_STATUS_MMS_ERROR_INVALID_SUBSCRIPTION_ID = 608; // 0x260

public static final int DOWNLOAD_STATUS_MMS_ERROR_IO_ERROR = 604; // 0x25c

public static final int DOWNLOAD_STATUS_MMS_ERROR_MMS_DISABLED_BY_CARRIER = 611; // 0x263

public static final int DOWNLOAD_STATUS_MMS_ERROR_NO_DATA_NETWORK = 607; // 0x25f

public static final int DOWNLOAD_STATUS_MMS_ERROR_RETRY = 605; // 0x25d

public static final int DOWNLOAD_STATUS_MMS_ERROR_UNABLE_CONNECT_MMS = 602; // 0x25a

public static final int DOWNLOAD_STATUS_MMS_ERROR_UNSPECIFIED = 600; // 0x258

public static final int DOWNLOAD_STATUS_OK = 0; // 0x0

public static final int DOWNLOAD_STATUS_RETRY_ON_CARRIER_NETWORK = 1; // 0x1

public static final int RECEIVE_OPTIONS_DEFAULT = 0; // 0x0

public static final int RECEIVE_OPTIONS_DROP = 1; // 0x1

public static final int RECEIVE_OPTIONS_SKIP_NOTIFY_WHEN_CREDENTIAL_PROTECTED_STORAGE_UNAVAILABLE = 2; // 0x2

public static final int SEND_FLAG_REQUEST_DELIVERY_STATUS = 1; // 0x1

public static final int SEND_STATUS_ERROR = 2; // 0x2

public static final int SEND_STATUS_MMS_ERROR_CONFIGURATION_ERROR = 406; // 0x196

public static final int SEND_STATUS_MMS_ERROR_DATA_DISABLED = 410; // 0x19a

public static final int SEND_STATUS_MMS_ERROR_HTTP_FAILURE = 403; // 0x193

public static final int SEND_STATUS_MMS_ERROR_INACTIVE_SUBSCRIPTION = 409; // 0x199

public static final int SEND_STATUS_MMS_ERROR_INVALID_APN = 401; // 0x191

public static final int SEND_STATUS_MMS_ERROR_INVALID_SUBSCRIPTION_ID = 408; // 0x198

public static final int SEND_STATUS_MMS_ERROR_IO_ERROR = 404; // 0x194

public static final int SEND_STATUS_MMS_ERROR_MMS_DISABLED_BY_CARRIER = 411; // 0x19b

public static final int SEND_STATUS_MMS_ERROR_NO_DATA_NETWORK = 407; // 0x197

public static final int SEND_STATUS_MMS_ERROR_RETRY = 405; // 0x195

public static final int SEND_STATUS_MMS_ERROR_UNABLE_CONNECT_MMS = 402; // 0x192

public static final int SEND_STATUS_MMS_ERROR_UNSPECIFIED = 400; // 0x190

public static final int SEND_STATUS_OK = 0; // 0x0

public static final int SEND_STATUS_RESULT_CANCELLED = 215; // 0xd7

public static final int SEND_STATUS_RESULT_ENCODING_ERROR = 212; // 0xd4

public static final int SEND_STATUS_RESULT_ERROR_FDN_CHECK_FAILURE = 204; // 0xcc

public static final int SEND_STATUS_RESULT_ERROR_GENERIC_FAILURE = 200; // 0xc8

public static final int SEND_STATUS_RESULT_ERROR_LIMIT_EXCEEDED = 203; // 0xcb

public static final int SEND_STATUS_RESULT_ERROR_NO_SERVICE = 202; // 0xca

public static final int SEND_STATUS_RESULT_ERROR_NULL_PDU = 201; // 0xc9

public static final int SEND_STATUS_RESULT_ERROR_SHORT_CODE_NEVER_ALLOWED = 206; // 0xce

public static final int SEND_STATUS_RESULT_ERROR_SHORT_CODE_NOT_ALLOWED = 205; // 0xcd

public static final int SEND_STATUS_RESULT_INVALID_ARGUMENTS = 208; // 0xd0

public static final int SEND_STATUS_RESULT_INVALID_SMSC_ADDRESS = 213; // 0xd5

public static final int SEND_STATUS_RESULT_INVALID_SMS_FORMAT = 210; // 0xd2

public static final int SEND_STATUS_RESULT_INVALID_STATE = 209; // 0xd1

public static final int SEND_STATUS_RESULT_NETWORK_ERROR = 211; // 0xd3

public static final int SEND_STATUS_RESULT_NETWORK_REJECT = 207; // 0xcf

public static final int SEND_STATUS_RESULT_OPERATION_NOT_ALLOWED = 214; // 0xd6

public static final int SEND_STATUS_RESULT_REQUEST_NOT_SUPPORTED = 216; // 0xd8

public static final int SEND_STATUS_RESULT_SMS_BLOCKED_DURING_EMERGENCY = 217; // 0xd9

public static final int SEND_STATUS_RESULT_SMS_SEND_RETRY_FAILED = 218; // 0xda

public static final int SEND_STATUS_RETRY_ON_CARRIER_NETWORK = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String SERVICE_INTERFACE = "android.service.carrier.CarrierMessagingService";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ResultCallback<T> {

public void onReceiveResult(@android.annotation.NonNull T result) throws android.os.RemoteException;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SendMmsResult {

public SendMmsResult(int sendStatus, @android.annotation.Nullable byte[] sendConfPdu) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getSendConfPdu() { throw new RuntimeException("Stub!"); }

public int getSendStatus() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SendMultipartSmsResult {

public SendMultipartSmsResult(int sendStatus, @android.annotation.Nullable int[] messageRefs) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public int[] getMessageRefs() { throw new RuntimeException("Stub!"); }

public int getSendStatus() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SendSmsResult {

public SendSmsResult(int sendStatus, int messageRef) { throw new RuntimeException("Stub!"); }

public int getMessageRef() { throw new RuntimeException("Stub!"); }

public int getSendStatus() { throw new RuntimeException("Stub!"); }
}

}

