/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.os;


/**
 * Encapsulates a single profiling trigger.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ProfilingTrigger {

ProfilingTrigger() { throw new RuntimeException("Stub!"); }

/**
 * The requester set rate limiting period in hours.
 *
 * The period is the minimum time the system should wait before providing another
 * profiling result for the same trigger; actual time between events may be longer.
 *
 * If the rate limiting period is set to 0, no app-provided rate limiting will be used.
 *
 * This rate limiting is in addition to any system level rate limiting that may be applied.
 */

public int getRateLimitingPeriodHours() { throw new RuntimeException("Stub!"); }

/**
 * The trigger type indicates which event should trigger the requested profiling.
 * @return Value is {@link android.os.ProfilingTrigger#TRIGGER_TYPE_NONE}, {@link android.os.ProfilingTrigger#TRIGGER_TYPE_APP_FULLY_DRAWN}, or {@link android.os.ProfilingTrigger#TRIGGER_TYPE_ANR}
 */

public int getTriggerType() { throw new RuntimeException("Stub!"); }

/**
 * Trigger occurs after an ANR has been identified, but before the system would attempt to kill
 * the app. The trigger does not necessarily indicate that the app was killed due to the ANR.
 */

public static final int TRIGGER_TYPE_ANR = 2; // 0x2

/** Trigger occurs after {@link Activity#reportFullyDrawn} is called for a cold start. */

public static final int TRIGGER_TYPE_APP_FULLY_DRAWN = 1; // 0x1

/** No trigger. Used in {@link android.os.ProfilingResult ProfilingResult} for non trigger caused results. */

public static final int TRIGGER_TYPE_NONE = 0; // 0x0
/**
 * Builder class to create a {@link android.os.ProfilingTrigger ProfilingTrigger} object.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Create a new builder instance to create a {@link android.os.ProfilingTrigger ProfilingTrigger} object.
 *
 * Requires a trigger type. An app can only have one registered trigger per trigger type.
 * Adding a new trigger with the same type will override the previously set one.
 *
 * @throws java.lang.IllegalArgumentException if the trigger type is not valid.

 * @param triggerType Value is {@link android.os.ProfilingTrigger#TRIGGER_TYPE_NONE}, {@link android.os.ProfilingTrigger#TRIGGER_TYPE_APP_FULLY_DRAWN}, or {@link android.os.ProfilingTrigger#TRIGGER_TYPE_ANR}
 */

public Builder(int triggerType) { throw new RuntimeException("Stub!"); }

/**
 * Build the {@link android.os.ProfilingTrigger ProfilingTrigger} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.ProfilingTrigger build() { throw new RuntimeException("Stub!"); }

/**
 * Set a rate limiting period in hours.
 *
 * The period is the minimum time the system should wait before providing another
 * profiling result for the same trigger; actual time between events may be longer.
 *
 * If the rate limiting period is not provided or set to 0, no app-provided rate limiting
 * will be used.
 *
 * This rate limiting is in addition to any system level rate limiting that may be applied.
 *
 * @throws java.lang.IllegalArgumentException if the value is less than 0.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.ProfilingTrigger.Builder setRateLimitingPeriodHours(int rateLimitingPeriodHours) { throw new RuntimeException("Stub!"); }
}

}

