/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Parcelable;

/**
 * A class representing a Wi-Fi P2P USD based service discovery configuration for
 * discovering the services.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pUsdBasedServiceDiscoveryConfig implements android.os.Parcelable {

WifiP2pUsdBasedServiceDiscoveryConfig() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the band to scan for services. See {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder#setBand(int) Builder.setBand(int)}

 * @return Value is {@link android.net.wifi.ScanResult#UNSPECIFIED}, {@link android.net.wifi.ScanResult#WIFI_BAND_24_GHZ}, {@link android.net.wifi.ScanResult#WIFI_BAND_5_GHZ}, {@link android.net.wifi.ScanResult#WIFI_BAND_6_GHZ}, or {@link android.net.wifi.ScanResult#WIFI_BAND_60_GHZ}
 */

public int getBand() { throw new RuntimeException("Stub!"); }

/**
 * Get the frequencies to scan for services. See {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder#setFrequenciesMhz(int[]) Builder.setFrequenciesMhz(int[])}

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public int[] getFrequenciesMhz() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig WifiP2pUsdBasedServiceDiscoveryConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a Builder with default values.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig WifiP2pUsdBasedServiceDiscoveryConfig} given the current requests made
 * on the builder.
 * @return {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig WifiP2pUsdBasedServiceDiscoveryConfig} constructed based on builder
 * method calls.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Specifies the band requested for service discovery. The band should
 * be one of the following band constants defined in {@code ScanResult#WIFI_BAND_24_GHZ},
 * {@code ScanResult#WIFI_BAND_5_GHZ} or {@code ScanResult#WIFI_BAND_6_GHZ}
 *
 * <p>
 *     {@link #setBand(int)} and {@link #setFrequenciesMhz(int[])} are
 *     mutually exclusive. Setting operating band and frequency both is invalid.
 * <p>
 *     Optional. {@code ScanResult#UNSPECIFIED} by default.
 *
 * @param band The requested band.
 * @return Instance of {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder Builder} to enable chaining of the builder method.
 *
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException - if the band specified is not one among the list
 *         of bands mentioned above.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder setBand(int band) { throw new RuntimeException("Stub!"); }

/**
 * Set the frequencies requested for service discovery.
 *
 * <p>
 *     {@link #setBand(int)} and {@link #setFrequenciesMhz(int[])} are
 *     mutually exclusive. Setting band and frequencies both is invalid.
 * <p>
 *     Optional. 2437 by default.
 * @param frequenciesMhz Frequencies in MHz to scan for services. This value cannot be an
 *                       empty array of frequencies.
 * This value cannot be {@code null}.
 * @return Instance of {@link android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder Builder} to enable chaining of the builder method.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig.Builder setFrequenciesMhz(@android.annotation.NonNull int[] frequenciesMhz) { throw new RuntimeException("Stub!"); }
}

}

