/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

import android.os.Parcelable;

/**
 * Representation of a Wi-Fi Service Set Identifier (SSID).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiSsid implements android.os.Parcelable {

WifiSsid() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object thatObject) { throw new RuntimeException("Stub!"); }

/**
 * Create a WifiSsid from the raw bytes. If the byte array is null, return an empty WifiSsid
 * object which will return an empty byte array and empty text.

 * @param bytes This value may be {@code null}.
 */

@android.annotation.NonNull
public static android.net.wifi.WifiSsid fromBytes(@android.annotation.Nullable byte[] bytes) { throw new RuntimeException("Stub!"); }

/**
 * Returns the raw byte array representing this SSID.
 * @return the SSID

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getBytes() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the string representation of the WifiSsid. If the SSID can be decoded as UTF-8, it
 * will be returned in plain text surrounded by double quotation marks. Otherwise, it is
 * returned as an unquoted string of hex digits. This format is consistent with
 * {@link android.net.wifi.WifiInfo#getSSID() WifiInfo.getSSID()} and {@link android.net.wifi.WifiConfiguration#SSID WifiConfiguration.SSID}.
 *
 * @return SSID as double-quoted plain text from UTF-8 or unquoted hex digits

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiSsid> CREATOR;
static { CREATOR = null; }
}

