// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * A class configuring the host resolution functionality. Note that while we refer to {@code
 * DNS} as the most common mechanism being used for brevity, settings apply to other means of
 * resolving hostnames like hosts file resolution.
 *
 * <p>Hostnames can be resolved in two ways - either by using the system resolver (using {@code
 * getaddrinfo} provided by system libraries), or by using a custom resolver which is tailored
 * for the HTTP networking stack.
 *
 * <p>The built-in stack provides several advantages over using the global system resolver:
 *
 * <ul>
 *   <li>It has been tailored to the needs of the HTTP networking stack, particularly speed and
 *       stability.
 *   <li>{@code getaddrinfo} is a blocking call which requires dedicating worker threads and makes
 *       cancellation impossible (we need to abandon the thread until the call completes)
 *   <li>The {@code getaddrinfo} interface gives no insight into the root cause of failures
 *   <li>{@code struct addrinfo} provides no TTL (Time To Live) of the returned addresses. This
 *       restricts flexibility of handling caching (e.g. allowing the use of stale DNS records) and
 *       requires us to either rely on OS DNS caches, or be extremely conservative with the TTL.
 * </ul>
 *
 * <p>Most configuration in this class is only applicable if the built-in DNS resolver is used.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DnsOptions {

DnsOptions() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setPersistHostCache(int) Builder.setPersistHostCache(int)}

 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getPersistHostCache() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setPersistHostCachePeriod Builder.setPersistHostCachePeriod}
 */

@android.annotation.Nullable
public java.time.Duration getPersistHostCachePeriod() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setPreestablishConnectionsToStaleDnsResults(int) Builder.setPreestablishConnectionsToStaleDnsResults(int)}

 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getPreestablishConnectionsToStaleDnsResults() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setStaleDns(int) Builder.setStaleDns(int)}

 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getStaleDns() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setStaleDnsOptions Builder.setStaleDnsOptions}
 */

@android.annotation.Nullable
public android.net.http.DnsOptions.StaleDnsOptions getStaleDnsOptions() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.DnsOptions.Builder#setUseHttpStackDnsResolver(int) Builder.setUseHttpStackDnsResolver(int)}

 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getUseHttpStackDnsResolver() { throw new RuntimeException("Stub!"); }

/**
 * Option is disabled.
 */

public static final int DNS_OPTION_DISABLED = 2; // 0x2

/**
 * Option is enabled.
 */

public static final int DNS_OPTION_ENABLED = 1; // 0x1

/**
 * Option is unspecified, platform default value will be used.
 */

public static final int DNS_OPTION_UNSPECIFIED = 0; // 0x0
/**
 * Builder for {@link android.net.http.DnsOptions DnsOptions}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates and returns the final {@link android.net.http.DnsOptions DnsOptions} instance, based on the values in this
 * builder.
 */

@android.annotation.NonNull
public android.net.http.DnsOptions build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether the DNS cache should be persisted to disk.
 *
 * <p>Only relevant if {@link android.net.http.HttpEngine.Builder#setStoragePath(java.lang.String) HttpEngine.Builder.setStoragePath(String)} is
 * set.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setPersistHostCache(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets the minimum period between subsequent writes to disk for DNS cache persistence.
 *
 * <p>Only relevant if {@link #setPersistHostCache(int)} is set to
 * {@link #DNS_OPTION_ENABLED}.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setPersistHostCachePeriod(@android.annotation.NonNull java.time.Duration persistHostCachePeriod) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Cronet should use stale cached DNS records to pre-establish connections.
 *
 * <p>If enabled, Cronet will optimistically pre-establish connections to servers that
 * matched the hostname at some point in the past and were cached but the cache entry
 * expired. Such connections won't be used further until a new DNS lookup confirms the
 * cached record was up to date.
 *
 * <p>To use cached DNS records straight away, use {@link #setStaleDns(int)} and {@link android.net.http.DnsOptions.StaleDnsOptions StaleDnsOptions} configuration options.
 *
 * <p>This option may not be available for all networking protocols.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setPreestablishConnectionsToStaleDnsResults(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to use stale DNS results at all.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setStaleDns(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets detailed configuration for stale DNS.
 *
 * Only relevant if {@link #setStaleDns(int)} is set.
 *
 * @return this builder for chaining.
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setStaleDnsOptions(@android.annotation.NonNull android.net.http.DnsOptions.StaleDnsOptions staleDnsOptions) { throw new RuntimeException("Stub!"); }

/**
 * Enables the use of the HTTP-stack-specific DNS resolver.
 *
 * <p>Setting this to {@link #DNS_OPTION_ENABLED} is necessary for other functionality
 * of {@link android.net.http.DnsOptions DnsOptions} to work, unless specified otherwise. See the {@link android.net.http.DnsOptions DnsOptions}
 * documentation for more details.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.Builder setUseHttpStackDnsResolver(int state) { throw new RuntimeException("Stub!"); }
}

/**
 * A class configuring the stale DNS functionality.
 *
 * <p>DNS resolution is one of the steps on the critical path to making a URL request, but it
 * can be slow for various reasons (underlying network latency, buffer bloat, packet loss,
 * etc.). Depending on the use case, it might be worthwhile for an app developer to trade off
 * guaranteed DNS record freshness for better availability of DNS records.
 *
 * <p>Stale results can include both:
 *
 * <ul>
 *   <li>results returned from the current network's DNS server, but past their time-to-live,
 *       and
 *   <li>results returned from a different network's DNS server, whether expired or not.
 * </ul>
 *
 * <p>For detailed explanation of the configuration options see javadoc on
 * {@link android.net.http.DnsOptions.StaleDnsOptions.Builder StaleDnsOptions.Builder} methods.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class StaleDnsOptions {

StaleDnsOptions() { throw new RuntimeException("Stub!"); }

/**
 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getAllowCrossNetworkUsage() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.time.Duration getFreshLookupTimeout() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.time.Duration getMaxExpiredDelay() { throw new RuntimeException("Stub!"); }

/**
 * @return Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 */

public int getUseStaleOnNameNotResolved() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.net.http.DnsOptions.StaleDnsOptions StaleDnsOptions}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates and returns the final {@link android.net.http.DnsOptions.StaleDnsOptions StaleDnsOptions} instance, based on the values
 * in this builder.
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.StaleDnsOptions build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to return results originating from other networks or not. Normally,
 * the HTTP stack clears the DNS cache entirely when switching connections, e.g. between
 * two Wi-Fi networks or from Wi-Fi to 4G.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.StaleDnsOptions.Builder setAllowCrossNetworkUsage(int state) { throw new RuntimeException("Stub!"); }

/**
 * Sets how long (in milliseconds) to wait for a DNS request to return before using a
 * stale result instead. If set to zero, returns stale results instantly but continues
 * the DNS request in the background to update the cache.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.StaleDnsOptions.Builder setFreshLookupTimeout(@android.annotation.NonNull java.time.Duration freshLookupTimeout) { throw new RuntimeException("Stub!"); }

/**
 * Sets how long (in milliseconds) past expiration to consider using expired results.
 * Setting the value to zero means expired records can be used indefinitely.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.StaleDnsOptions.Builder setMaxExpiredDelay(@android.annotation.NonNull java.time.Duration maxExpiredDelay) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to allow use of stale DNS results when network resolver fails to resolve
 * the hostname.
 *
 * <p>Depending on the use case, if the DNS resolver quickly sees a fresh failure, it
 * may be desirable to use the failure as it is technically the fresher result, and we
 * had such a fresh result quickly; or, prefer having any result (even if stale) to use
 * over dealing with a DNS failure.
 *
 * @param state one of the DNS_OPTION_* values
 * Value is {@link android.net.http.DnsOptions#DNS_OPTION_UNSPECIFIED}, {@link android.net.http.DnsOptions#DNS_OPTION_ENABLED}, or {@link android.net.http.DnsOptions#DNS_OPTION_DISABLED}
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.DnsOptions.StaleDnsOptions.Builder setUseStaleOnNameNotResolved(int state) { throw new RuntimeException("Stub!"); }
}

}

}

