/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.session;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaSession {

public MediaSession(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String tag) { throw new RuntimeException("Stub!"); }

public MediaSession(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String tag, @android.annotation.Nullable android.os.Bundle sessionInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.session.MediaController getController() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.session.MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.session.MediaSession.Token getSessionToken() { throw new RuntimeException("Stub!"); }

public boolean isActive() { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void sendSessionEvent(@android.annotation.NonNull java.lang.String event, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void setActive(boolean active) { throw new RuntimeException("Stub!"); }

public void setCallback(@android.annotation.Nullable android.media.session.MediaSession.Callback callback) { throw new RuntimeException("Stub!"); }

public void setCallback(@android.annotation.Nullable android.media.session.MediaSession.Callback callback, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void setFlags(int flags) { throw new RuntimeException("Stub!"); }

public void setMediaButtonBroadcastReceiver(@android.annotation.Nullable android.content.ComponentName broadcastReceiver) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setMediaButtonReceiver(@android.annotation.Nullable android.app.PendingIntent mbr) { throw new RuntimeException("Stub!"); }

public void setMetadata(@android.annotation.Nullable android.media.MediaMetadata metadata) { throw new RuntimeException("Stub!"); }

public void setPlaybackState(@android.annotation.Nullable android.media.session.PlaybackState state) { throw new RuntimeException("Stub!"); }

public void setPlaybackToLocal(android.media.AudioAttributes attributes) { throw new RuntimeException("Stub!"); }

public void setPlaybackToRemote(@android.annotation.NonNull android.media.VolumeProvider volumeProvider) { throw new RuntimeException("Stub!"); }

public void setQueue(@android.annotation.Nullable java.util.List<android.media.session.MediaSession.QueueItem> queue) { throw new RuntimeException("Stub!"); }

public void setQueueTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

public void setRatingType(int type) { throw new RuntimeException("Stub!"); }

public void setSessionActivity(@android.annotation.Nullable android.app.PendingIntent pi) { throw new RuntimeException("Stub!"); }

@Deprecated public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1; // 0x1

@Deprecated public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

public void onCommand(@android.annotation.NonNull java.lang.String command, @android.annotation.Nullable android.os.Bundle args, @android.annotation.Nullable android.os.ResultReceiver cb) { throw new RuntimeException("Stub!"); }

public void onCustomAction(@android.annotation.NonNull java.lang.String action, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onFastForward() { throw new RuntimeException("Stub!"); }

public boolean onMediaButtonEvent(@android.annotation.NonNull android.content.Intent mediaButtonIntent) { throw new RuntimeException("Stub!"); }

public void onPause() { throw new RuntimeException("Stub!"); }

public void onPlay() { throw new RuntimeException("Stub!"); }

public void onPlayFromMediaId(java.lang.String mediaId, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPlayFromSearch(java.lang.String query, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPlayFromUri(android.net.Uri uri, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPrepare() { throw new RuntimeException("Stub!"); }

public void onPrepareFromMediaId(java.lang.String mediaId, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPrepareFromSearch(java.lang.String query, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPrepareFromUri(android.net.Uri uri, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onRewind() { throw new RuntimeException("Stub!"); }

public void onSeekTo(long pos) { throw new RuntimeException("Stub!"); }

public void onSetPlaybackSpeed(float speed) { throw new RuntimeException("Stub!"); }

public void onSetRating(@android.annotation.NonNull android.media.Rating rating) { throw new RuntimeException("Stub!"); }

public void onSkipToNext() { throw new RuntimeException("Stub!"); }

public void onSkipToPrevious() { throw new RuntimeException("Stub!"); }

public void onSkipToQueueItem(long id) { throw new RuntimeException("Stub!"); }

public void onStop() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class QueueItem implements android.os.Parcelable {

public QueueItem(android.media.MediaDescription description, long id) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public android.media.MediaDescription getDescription() { throw new RuntimeException("Stub!"); }

public long getQueueId() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.session.MediaSession.QueueItem> CREATOR;
static { CREATOR = null; }

public static final int UNKNOWN_ID = -1; // 0xffffffff
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Token implements android.os.Parcelable {

Token() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.session.MediaSession.Token> CREATOR;
static { CREATOR = null; }
}

}

