/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

import android.location.provider.ProviderProperties;

/**
 * Information about the properties of a location provider.
 *
 * @deprecated This class is incapable of representing unknown provider properties and may return
 * incorrect results on the rare occasion when a provider's properties are unknown. Prefer using
 * {@link android.location.LocationManager#getProviderProperties(java.lang.String) LocationManager.getProviderProperties(String)} to retrieve {@link android.location.provider.ProviderProperties ProviderProperties}
 * instead.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public class LocationProvider {

@Deprecated
LocationProvider() { throw new RuntimeException("Stub!"); }

/**
 * Returns the rough accuracy of this provider, one of the ProviderProperties.ACCURACY_*
 * constants.
 */

@Deprecated
public int getAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of this provider.
 */

@Deprecated
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the power requirement for this provider, one of the ProviderProperties.POWER_USAGE_*
 * constants.
 */

@Deprecated
public int getPowerRequirement() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the use of this provider may result in a
 * monetary charge to the user, false if use is free.  It is up to
 * each provider to give accurate information.
 */

@Deprecated
public boolean hasMonetaryCost() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if this provider meets the given criteria,
 * false otherwise.
 */

@Deprecated
public boolean meetsCriteria(android.location.Criteria criteria) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider requires access to an appropriate
 * cellular network (e.g., to make use of cell tower IDs), false
 * otherwise.
 */

@Deprecated
public boolean requiresCell() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider requires access to a
 * data network (e.g., the Internet), false otherwise.
 */

@Deprecated
public boolean requiresNetwork() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider requires access to a
 * satellite-based positioning system (e.g., GPS), false
 * otherwise.
 */

@Deprecated
public boolean requiresSatellite() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider is able to provide altitude
 * information, false otherwise.  A provider that reports altitude
 * under most circumstances but may occassionally not report it
 * should return true.
 */

@Deprecated
public boolean supportsAltitude() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider is able to provide bearing
 * information, false otherwise.  A provider that reports bearing
 * under most circumstances but may occassionally not report it
 * should return true.
 */

@Deprecated
public boolean supportsBearing() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the provider is able to provide speed
 * information, false otherwise.  A provider that reports speed
 * under most circumstances but may occassionally not report it
 * should return true.
 */

@Deprecated
public boolean supportsSpeed() { throw new RuntimeException("Stub!"); }

/**
 * @deprecated Location provider statuses are no longer supported.
 */

@Deprecated public static final int AVAILABLE = 2; // 0x2

/**
 * @deprecated Location provider statuses are no longer supported.
 */

@Deprecated public static final int OUT_OF_SERVICE = 0; // 0x0

/**
 * @deprecated Location provider statuses are no longer supported.
 */

@Deprecated public static final int TEMPORARILY_UNAVAILABLE = 1; // 0x1
}

