/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

import java.util.concurrent.Executor;

/**
 * GNSS chipset capabilities.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssCapabilities implements android.os.Parcelable {

GnssCapabilities() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.location.GnssSignalType GnssSignalType}s that the GNSS chipset supports.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.location.GnssSignalType> getGnssSignalTypes() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link #CAPABILITY_SUPPORTED} if GNSS chipset supports accumulated delta
 * range, {@link #CAPABILITY_UNSUPPORTED} if GNSS chipset does not support accumulated
 * delta range, and {@link #CAPABILITY_UNKNOWN} if it is unknown, which means GNSS
 * chipset may or may not support accumulated delta range.
 *
 * <p>The accumulated delta range information can be queried in
 * {@link android.location.GnssMeasurement#getAccumulatedDeltaRangeState()},
 * {@link android.location.GnssMeasurement#getAccumulatedDeltaRangeMeters()}, and
 * {@link android.location.GnssMeasurement#getAccumulatedDeltaRangeUncertaintyMeters()}.

 * @return Value is either <code>0</code> or a combination of {@link android.location.GnssCapabilities#CAPABILITY_UNKNOWN}, {@link android.location.GnssCapabilities#CAPABILITY_SUPPORTED}, and {@link android.location.GnssCapabilities#CAPABILITY_UNSUPPORTED}
 */

public int hasAccumulatedDeltaRange() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports antenna info, {@code false} otherwise.
 *
 * @see android.location.LocationManager#registerAntennaInfoListener(Executor, GnssAntennaInfo.Listener)
 */

public boolean hasAntennaInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports geofencing, {@code false} otherwise.
 */

public boolean hasGeofencing() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports antenna info, {@code false} otherwise.
 *
 * @deprecated Use {@link #hasAntennaInfo()} instead.
 */

@Deprecated
public boolean hasGnssAntennaInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports low power mode, {@code false} otherwise.
 *
 * <p>The low power mode is defined in GNSS HAL. When the low power mode is active, the GNSS
 * hardware must make strong tradeoffs to substantially restrict power use.
 */

public boolean hasLowPowerMode() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measurement corrections, {@code false}
 * otherwise.
 */

public boolean hasMeasurementCorrections() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports per satellite excess-path-length measurement
 * corrections, {@code false} otherwise.
 */

public boolean hasMeasurementCorrectionsExcessPathLength() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset will benefit from measurement corrections for driving
 * use case if provided, {@code false} otherwise.
 */

public boolean hasMeasurementCorrectionsForDriving() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports line-of-sight satellite identification
 * measurement corrections, {@code false} otherwise.
 */

public boolean hasMeasurementCorrectionsLosSats() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports reflecting plane measurement corrections,
 * {@code false} otherwise.
 */

public boolean hasMeasurementCorrectionsReflectingPlane() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports correlation vectors as part of measurements
 * outputs, {@code false} otherwise.
 */

public boolean hasMeasurementCorrelationVectors() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measurements, {@code false} otherwise.
 *
 * @see android.location.LocationManager#registerGnssMeasurementsCallback(Executor, GnssMeasurementsEvent.Callback)
 */

public boolean hasMeasurements() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports Mobile Station Assisted assitance,
 * {@code false} otherwise.
 */

public boolean hasMsa() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports Mobile Station Based assistance, {@code false}
 * otherwise.
 */

public boolean hasMsb() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports navigation messages, {@code false} otherwise.
 *
 * @see android.location.LocationManager#registerGnssNavigationMessageCallback(Executor, GnssNavigationMessage.Callback)
 */

public boolean hasNavigationMessages() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset requests periodic time signal injection from the
 * platform in addition to on-demand and occasional time updates, {@code false} otherwise.
 *
 * <p><em>Note: The naming of this capability and the behavior it controls differ substantially.
 * This is the result of a historic implementation bug, b/73893222.</em>
 */

public boolean hasOnDemandTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring multi-band acquisition power,
 * {@code false} otherwise.
 */

public boolean hasPowerMultibandAcquisition() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring multi-band tracking power,
 * {@code false} otherwise.
 */

public boolean hasPowerMultibandTracking() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring OEM defined mode power, {@code false}
 * otherwise.
 */

public boolean hasPowerOtherModes() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring single-band acquisition power,
 * {@code false} otherwise.
 */

public boolean hasPowerSinglebandAcquisition() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring single-band tracking power,
 * {@code false} otherwise.
 */

public boolean hasPowerSinglebandTracking() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports measuring power totals, {@code false}
 * otherwise.
 */

public boolean hasPowerTotal() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports satellite blocklists, {@code false} otherwise.
 */

public boolean hasSatelliteBlocklist() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports satellite PVT, {@code false} otherwise.
 */

public boolean hasSatellitePvt() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports scheduling, {@code false} otherwise.
 */

public boolean hasScheduling() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if GNSS chipset supports single shot locating, {@code false} otherwise.
 */

public boolean hasSingleShotFix() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

/** The capability is supported. */

public static final int CAPABILITY_SUPPORTED = 1; // 0x1

/** The capability is unknown to be supported or not. */

public static final int CAPABILITY_UNKNOWN = 0; // 0x0

/** The capability is not supported. */

public static final int CAPABILITY_UNSUPPORTED = 2; // 0x2

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssCapabilities> CREATOR;
static { CREATOR = null; }
/**
 * Builder for GnssCapabilities.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param capabilities This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.GnssCapabilities capabilities) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new GnssCapabilities.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities build() { throw new RuntimeException("Stub!"); }

/**
 * Sets a list of {@link android.location.GnssSignalType GnssSignalType}.
 
 * @param gnssSignalTypes This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setGnssSignalTypes(@android.annotation.NonNull java.util.List<android.location.GnssSignalType> gnssSignalTypes) { throw new RuntimeException("Stub!"); }

/**
 * Sets accumulated delta range capability.
 
 * @param capable Value is either <code>0</code> or a combination of {@link android.location.GnssCapabilities#CAPABILITY_UNKNOWN}, {@link android.location.GnssCapabilities#CAPABILITY_SUPPORTED}, and {@link android.location.GnssCapabilities#CAPABILITY_UNSUPPORTED}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasAccumulatedDeltaRange(int capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets antenna info capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasAntennaInfo(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets geofencing capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasGeofencing(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets low power mode capability.
 *
 * <p>The low power mode is defined in GNSS HAL. When the low power mode is active, the GNSS
 * hardware must make strong tradeoffs to substantially restrict power use.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasLowPowerMode(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurement corrections capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrections(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurement corrections excess path length capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsExcessPathLength(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurement corrections for driving capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsForDriving(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurement corrections line-of-sight satellites capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsLosSats(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurement corrections reflecting plane capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrectionsReflectingPlane(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets correlation vector capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurementCorrelationVectors(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets measurements capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMeasurements(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets Mobile Station Assisted capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMsa(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets Mobile Station Based capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasMsb(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets navigation messages capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasNavigationMessages(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets on demand time capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasOnDemandTime(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets power multi-band acquisition capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerMultibandAcquisition(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets power multi-band tracking capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerMultibandTracking(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets OEM-defined power modes capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerOtherModes(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets power single-band acquisition capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerSinglebandAcquisition(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets power single-band tracking capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerSinglebandTracking(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets power totals capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasPowerTotal(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets satellite blocklist capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSatelliteBlocklist(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets satellite PVT capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSatellitePvt(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets scheduling capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasScheduling(boolean capable) { throw new RuntimeException("Stub!"); }

/**
 * Sets single shot locating capability.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssCapabilities.Builder setHasSingleShotFix(boolean capable) { throw new RuntimeException("Stub!"); }
}

}

