/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

import java.io.IOException;
import java.util.Locale;

/**
 * A class for handling geocoding and reverse geocoding. Geocoding is the process of transforming a
 * street address or other description of a location into a (latitude, longitude) coordinate.
 * Reverse geocoding is the process of transforming a (latitude, longitude) coordinate into a
 * (partial) address. The amount of detail in a reverse geocoded location description may vary, for
 * example one might contain the full street address of the closest building, while another might
 * contain only a city name and postal code.
 *
 * <p>Use the isPresent() method to determine whether a Geocoder implementation exists on the
 * current device. If no implementation is present, any attempt to geocode will result in an error.
 *
 * <p>Geocoder implementations are only required to make a best effort to return results in the
 * chosen locale. Note that geocoder implementations may return results in other locales if they
 * have no information available for the chosen locale.
 *
 * <p class="note"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful or
 * correct. Do not use this API for any safety-critical or regulatory compliance purpose.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Geocoder {

/**
 * Constructs a Geocoder localized for {@link java.util.Locale#getDefault() Locale.getDefault()}.
 * @param context This value cannot be {@code null}.
 */

public Geocoder(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a Geocoder localized for the given locale. Note that geocoder implementations will
 * only make a best effort to return results in the given locale, and there is no guarantee that
 * returned results will be in the specific locale.
 
 * @param context This value cannot be {@code null}.

 * @param locale This value cannot be {@code null}.
 */

public Geocoder(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.util.Locale locale) { throw new RuntimeException("Stub!"); }

/**
 * Returns an array of Addresses that attempt to describe the area immediately surrounding the
 * given latitude and longitude. The returned addresses should be localized for the locale
 * provided to this class's constructor.
 *
 * <p class="warning"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * <p class="warning"><strong>Warning:</strong> This API may hit the network, and may block for
 * excessive amounts of time. It's strongly encouraged to use the asynchronous version of this
 * API. If that is not possible, this should be run on a background thread to avoid blocking
 * other operations.
 *
 * @param latitude the latitude a point for the search
 * Value is between -90D and 90D inclusive
 * @param longitude the longitude a point for the search
 * Value is between -180D and 180D inclusive
 * @param maxResults max number of addresses to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @return a list of Address objects. Returns null or empty list if no matches were found or
 *     there is no backend service available.
 * @throws java.lang.IllegalArgumentException if latitude or longitude is invalid
 * @throws java.io.IOException if there is a failure
 * @deprecated Use {@link #getFromLocation(double,double,int,android.location.Geocoder.GeocodeListener)} instead to
 *     avoid blocking a thread waiting for results.
 */

@Deprecated
@android.annotation.Nullable
public java.util.List<android.location.Address> getFromLocation(double latitude, double longitude, int maxResults) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Provides an array of Addresses that attempt to describe the area immediately surrounding the
 * given latitude and longitude. The returned addresses should be localized for the locale
 * provided to this class's constructor.
 *
 * <p class="warning"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * @param latitude the latitude a point for the search
 * Value is between -90D and 90D inclusive
 * @param longitude the longitude a point for the search
 * Value is between -180D and 180D inclusive
 * @param maxResults max number of addresses to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @param listener a listener for receiving results
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if latitude or longitude is invalid
 */

public void getFromLocation(double latitude, double longitude, int maxResults, @android.annotation.NonNull android.location.Geocoder.GeocodeListener listener) { throw new RuntimeException("Stub!"); }

/**
 * Returns an array of Addresses that attempt to describe the named location, which may be a
 * place name such as "Dalvik, Iceland", an address such as "1600 Amphitheatre Parkway, Mountain
 * View, CA", an airport code such as "SFO", and so forth. The returned addresses should be
 * localized for the locale provided to this class's constructor.
 *
 * <p class="note"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * <p class="warning"><strong>Warning:</strong> This API may hit the network, and may block for
 * excessive amounts of time. It's strongly encouraged to use the asynchronous version of this
 * API. If that is not possible, this should be run on a background thread to avoid blocking
 * other operations.
 *
 * @param locationName a user-supplied description of a location
 * This value cannot be {@code null}.
 * @param maxResults max number of results to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @return a list of Address objects. Returns null or empty list if no matches were found or
 *     there is no backend service available.
 * @throws java.lang.IllegalArgumentException if locationName is null
 * @throws java.io.IOException if there is a failure
 * @deprecated Use {@link #getFromLocationName(java.lang.String,int,android.location.Geocoder.GeocodeListener)} instead to avoid
 *     blocking a thread waiting for results.
 */

@Deprecated
@android.annotation.Nullable
public java.util.List<android.location.Address> getFromLocationName(@android.annotation.NonNull java.lang.String locationName, int maxResults) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Provides an array of Addresses that attempt to describe the named location, which may be a
 * place name such as "Dalvik, Iceland", an address such as "1600 Amphitheatre Parkway, Mountain
 * View, CA", an airport code such as "SFO", and so forth. The returned addresses should be
 * localized for the locale provided to this class's constructor.
 *
 * <p class="note"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * @param locationName a user-supplied description of a location
 * This value cannot be {@code null}.
 * @param maxResults max number of results to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @param listener a listener for receiving results
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if locationName is null
 */

public void getFromLocationName(@android.annotation.NonNull java.lang.String locationName, int maxResults, @android.annotation.NonNull android.location.Geocoder.GeocodeListener listener) { throw new RuntimeException("Stub!"); }

/**
 * Returns an array of Addresses that attempt to describe the named location, which may be a
 * place name such as "Dalvik, Iceland", an address such as "1600 Amphitheatre Parkway, Mountain
 * View, CA", an airport code such as "SFO", and so forth. The returned addresses should be
 * localized for the locale provided to this class's constructor.
 *
 * <p>You may specify a bounding box for the search results by including the latitude and
 * longitude of the lower left point and upper right point of the box.
 *
 * <p class="note"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * <p class="warning"><strong>Warning:</strong> This API may hit the network, and may block for
 * excessive amounts of time. It's strongly encouraged to use the asynchronous version of this
 * API. If that is not possible, this should be run on a background thread to avoid blocking
 * other operations.
 *
 * @param locationName a user-supplied description of a location
 * This value cannot be {@code null}.
 * @param maxResults max number of addresses to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @param lowerLeftLatitude the latitude of the lower left corner of the bounding box
 * Value is between -90D and 90D inclusive
 * @param lowerLeftLongitude the longitude of the lower left corner of the bounding box
 * Value is between -180D and 180D inclusive
 * @param upperRightLatitude the latitude of the upper right corner of the bounding box
 * Value is between -90D and 90D inclusive
 * @param upperRightLongitude the longitude of the upper right corner of the bounding box
 * Value is between -180D and 180D inclusive
 * @return a list of Address objects. Returns null or empty list if no matches were found or
 *     there is no backend service available.
 * @throws java.lang.IllegalArgumentException if locationName is null
 * @throws java.lang.IllegalArgumentException if any latitude or longitude is invalid
 * @throws java.io.IOException if there is a failure
 * @deprecated Use {@link #getFromLocationName(java.lang.String,int,double,double,double,double,android.location.Geocoder.GeocodeListener)} instead to avoid blocking a thread waiting for results.
 */

@Deprecated
@android.annotation.Nullable
public java.util.List<android.location.Address> getFromLocationName(@android.annotation.NonNull java.lang.String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Returns an array of Addresses that attempt to describe the named location, which may be a
 * place name such as "Dalvik, Iceland", an address such as "1600 Amphitheatre Parkway, Mountain
 * View, CA", an airport code such as "SFO", and so forth. The returned addresses should be
 * localized for the locale provided to this class's constructor.
 *
 * <p>You may specify a bounding box for the search results by including the latitude and
 * longitude of the lower left point and upper right point of the box.
 *
 * <p class="note"><strong>Warning:</strong> Geocoding services may provide no guarantees on
 * availability or accuracy. Results are a best guess, and are not guaranteed to be meaningful
 * or correct. Do <b>NOT</b> use this API for any safety-critical or regulatory compliance
 * purposes.
 *
 * @param locationName a user-supplied description of a location
 * This value cannot be {@code null}.
 * @param maxResults max number of addresses to return. Smaller numbers (1 to 5) are recommended
 * Value is 1 or greater
 * @param lowerLeftLatitude the latitude of the lower left corner of the bounding box
 * Value is between -90D and 90D inclusive
 * @param lowerLeftLongitude the longitude of the lower left corner of the bounding box
 * Value is between -180D and 180D inclusive
 * @param upperRightLatitude the latitude of the upper right corner of the bounding box
 * Value is between -90D and 90D inclusive
 * @param upperRightLongitude the longitude of the upper right corner of the bounding box
 * Value is between -180D and 180D inclusive
 * @param listener a listener for receiving results
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if locationName is null
 * @throws java.lang.IllegalArgumentException if any latitude or longitude is invalid
 */

public void getFromLocationName(@android.annotation.NonNull java.lang.String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, @android.annotation.NonNull android.location.Geocoder.GeocodeListener listener) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if there is a geocoder implementation present on the device that may return
 * results. If true, there is still no guarantee that any individual geocoding attempt will
 * succeed.
 */

public static boolean isPresent() { throw new RuntimeException("Stub!"); }
/**
 * A listener for asynchronous geocoding results. Only one of the methods will ever be invoked
 * per geocoding attempt. There are no guarantees on how long it will take for a method to be
 * invoked, nor any guarantees on the format or availability of error information.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface GeocodeListener {

/**
 * Invoked when geocoding fails, with an optional error message.
 * @param errorMessage This value may be {@code null}.
 */

public default void onError(@android.annotation.Nullable java.lang.String errorMessage) { throw new RuntimeException("Stub!"); }

/**
 * Invoked when geocoding completes successfully. May return an empty list.
 * @param addresses This value cannot be {@code null}.
 */

public void onGeocode(@android.annotation.NonNull java.util.List<android.location.Address> addresses);
}

}

