/* GENERATED SOURCE. DO NOT MODIFY. */
// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/*
 *******************************************************************************
 * Copyright (C) 2004-2016, Google Inc, International Business Machines
 * Corporation and others. All Rights Reserved.
 *******************************************************************************
 */

package android.icu.util;


/**
 * A unit such as length, mass, volume, currency, etc.  A unit is
 * coupled with a numeric amount to produce a Measure. MeasureUnit objects are immutable.
 * All subclasses must guarantee that. (However, subclassing is discouraged.)
 *
 * @see android.icu.util.Measure
 * @author Alan Liu
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MeasureUnit implements java.io.Serializable {

MeasureUnit() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public boolean equals(java.lang.Object rhs) { throw new RuntimeException("Stub!"); }

/**
 * Construct a MeasureUnit from a CLDR Core Unit Identifier, defined in UTS
 * 35. (Core unit identifiers and mixed unit identifiers are supported, long
 * unit identifiers are not.) Validates and canonicalizes the identifier.
 *
 * Note: dimensionless <code>MeasureUnit</code> is <code>null</code>
 *
 * <pre>
 * MeasureUnit example = MeasureUnit::forIdentifier("furlong-per-nanosecond")
 * </pre>
 *
 * @param identifier CLDR Unit Identifier
 * @throws java.lang.IllegalArgumentException if the identifier is invalid.
 */

public static android.icu.util.MeasureUnit forIdentifier(java.lang.String identifier) { throw new RuntimeException("Stub!"); }

/**
 * Get all of the available units. Returned set is unmodifiable.
 */

public static synchronized java.util.Set<android.icu.util.MeasureUnit> getAvailable() { throw new RuntimeException("Stub!"); }

/**
 * For the given type, return the available units.
 * @param type the type
 * @return the available units for type. Returned set is unmodifiable.
 */

public static java.util.Set<android.icu.util.MeasureUnit> getAvailable(java.lang.String type) { throw new RuntimeException("Stub!"); }

/**
 * Get all of the available units' types. Returned set is unmodifiable.
 */

public static java.util.Set<java.lang.String> getAvailableTypes() { throw new RuntimeException("Stub!"); }

/**
 * Compute the complexity of the unit. See Complexity for more information.
 *
 * @return The unit complexity.
 */

public android.icu.util.MeasureUnit.Complexity getComplexity() { throw new RuntimeException("Stub!"); }

/**
 * Returns the dimensionality (power) of this MeasureUnit. For example, if the unit is square,
 * then 2 is returned.
 * <p>
 * NOTE: Only works on SINGLE units. If this is a COMPOUND or MIXED unit, an exception will be thrown.
 * For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @return The dimensionality (power) of this simple unit.
 * @throws java.lang.UnsupportedOperationException if the unit is COMPOUND or MIXED.
 */

public int getDimensionality() { throw new RuntimeException("Stub!"); }

/**
 * Get CLDR Unit Identifier for this MeasureUnit, as defined in UTS 35.
 *
 * @return The string form of this unit.
 */

public java.lang.String getIdentifier() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current SI or binary prefix of this SINGLE unit. For example,
 * if the unit has the prefix "kilo", then MeasurePrefix.KILO is returned.
 * <p>
 * NOTE: Only works on SINGLE units. If this is a COMPOUND or MIXED unit, an
 * error will occur. For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @return The prefix of this SINGLE unit, from MeasurePrefix.
 * @throws java.lang.UnsupportedOperationException if the unit is COMPOUND or MIXED.
 */

public android.icu.util.MeasureUnit.MeasurePrefix getPrefix() { throw new RuntimeException("Stub!"); }

/**
 * Get the subType, such as “foot”. May return null.
 */

public java.lang.String getSubtype() { throw new RuntimeException("Stub!"); }

/**
 * Get the type, such as "length". May return null.
 */

public java.lang.String getType() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Computes the product of this unit with another unit. This is a way to build units from
 * constituent parts.
 * <p>
 * The numerator and denominator are preserved through this operation.
 * <p>
 * For example, if the receiver is "kilowatt" and the argument is "hour-per-day", then the
 * unit "kilowatt-hour-per-day" is returned.
 * <p>
 * NOTE: Only works on SINGLE and COMPOUND units. If either unit (receivee and argument) is a
 * MIXED unit, an error will occur. For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @param other The MeasureUnit to multiply with the target.
 * @return The product of the target unit with the provided unit.
 * @throws java.lang.UnsupportedOperationException if the unit is MIXED.
 */

public android.icu.util.MeasureUnit product(android.icu.util.MeasureUnit other) { throw new RuntimeException("Stub!"); }

/**
 * Computes the reciprocal of this MeasureUnit, with the numerator and denominator flipped.
 * <p>
 * For example, if the receiver is "meter-per-second", the unit "second-per-meter" is returned.
 * <p>
 * NOTE: Only works on SINGLE and COMPOUND units. If this is a MIXED unit, an error will
 * occur. For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @return The reciprocal of the target unit.
 * @throws java.lang.UnsupportedOperationException if the unit is MIXED.
 */

public android.icu.util.MeasureUnit reciprocal() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of SINGLE units contained within a sequence of COMPOUND units.
 * <p>
 * Examples:
 * - Given "meter-kilogram-per-second", three units will be returned: "meter",
 * "kilogram", and "per-second".
 * - Given "hour+minute+second", three units will be returned: "hour", "minute",
 * and "second".
 * <p>
 * If this is a SINGLE unit, a list of length 1 will be returned.
 *
 * @return An unmodifiable list of single units
 */

public java.util.List<android.icu.util.MeasureUnit> splitToSingleUnits() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Creates a MeasureUnit which is this SINGLE unit augmented with the specified dimensionality
 * (power). For example, if dimensionality is 2, the unit will be squared.
 * <p>
 * NOTE: Only works on SINGLE units. If this is a COMPOUND or MIXED unit, an exception is thrown.
 * For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @param dimensionality The dimensionality (power).
 * @return A new SINGLE unit.
 * @throws java.lang.UnsupportedOperationException if the unit is COMPOUND or MIXED.
 */

public android.icu.util.MeasureUnit withDimensionality(int dimensionality) { throw new RuntimeException("Stub!"); }

/**
 * Creates a MeasureUnit which is this SINGLE unit augmented with the specified prefix.
 * For example, MeasurePrefix.KILO for "kilo", or MeasurePrefix.KIBI for "kibi".
 * May return {@code this} if this unit already has that prefix.
 * <p>
 * There is sufficient locale data to format all standard prefixes.
 * <p>
 * NOTE: Only works on SINGLE units. If this is a COMPOUND or MIXED unit, an error will
 * occur. For more information, {@link android.icu.util.MeasureUnit.Complexity Complexity}.
 *
 * @param prefix The prefix, from MeasurePrefix.
 * @return A new SINGLE unit.
 * @throws java.lang.UnsupportedOperationException if this unit is a COMPOUND or MIXED unit.
 */

public android.icu.util.MeasureUnit withPrefix(android.icu.util.MeasureUnit.MeasurePrefix prefix) { throw new RuntimeException("Stub!"); }

/**
 * Constant for unit of area: acre
 */

public static final android.icu.util.MeasureUnit ACRE;
static { ACRE = null; }

/**
 * Constant for unit of volume: acre-foot
 */

public static final android.icu.util.MeasureUnit ACRE_FOOT;
static { ACRE_FOOT = null; }

/**
 * Constant for unit of electric: ampere
 */

public static final android.icu.util.MeasureUnit AMPERE;
static { AMPERE = null; }

/**
 * Constant for unit of angle: arc-minute
 */

public static final android.icu.util.MeasureUnit ARC_MINUTE;
static { ARC_MINUTE = null; }

/**
 * Constant for unit of angle: arc-second
 */

public static final android.icu.util.MeasureUnit ARC_SECOND;
static { ARC_SECOND = null; }

/**
 * Constant for unit of length: astronomical-unit
 */

public static final android.icu.util.MeasureUnit ASTRONOMICAL_UNIT;
static { ASTRONOMICAL_UNIT = null; }

/**
 * Constant for unit of pressure: atmosphere
 */

public static final android.icu.util.MeasureUnit ATMOSPHERE;
static { ATMOSPHERE = null; }

/**
 * Constant for unit of speed: beaufort
 */

public static final android.icu.util.MeasureUnit BEAUFORT;
static { BEAUFORT = null; }

/**
 * Constant for unit of digital: bit
 */

public static final android.icu.util.MeasureUnit BIT;
static { BIT = null; }

/**
 * Constant for unit of volume: bushel
 */

public static final android.icu.util.MeasureUnit BUSHEL;
static { BUSHEL = null; }

/**
 * Constant for unit of digital: byte
 */

public static final android.icu.util.MeasureUnit BYTE;
static { BYTE = null; }

/**
 * Constant for unit of energy: calorie
 */

public static final android.icu.util.MeasureUnit CALORIE;
static { CALORIE = null; }

/**
 * Constant for unit of light: candela
 */

public static final android.icu.util.MeasureUnit CANDELA;
static { CANDELA = null; }

/**
 * Constant for unit of mass: carat
 */

public static final android.icu.util.MeasureUnit CARAT;
static { CARAT = null; }

/**
 * Constant for unit of temperature: celsius
 */

public static final android.icu.util.MeasureUnit CELSIUS;
static { CELSIUS = null; }

/**
 * Constant for unit of volume: centiliter
 */

public static final android.icu.util.MeasureUnit CENTILITER;
static { CENTILITER = null; }

/**
 * Constant for unit of length: centimeter
 */

public static final android.icu.util.MeasureUnit CENTIMETER;
static { CENTIMETER = null; }

/**
 * Constant for unit of duration: century
 */

public static final android.icu.util.MeasureUnit CENTURY;
static { CENTURY = null; }

/**
 * Constant for unit of volume: cubic-centimeter
 */

public static final android.icu.util.MeasureUnit CUBIC_CENTIMETER;
static { CUBIC_CENTIMETER = null; }

/**
 * Constant for unit of volume: cubic-foot
 */

public static final android.icu.util.MeasureUnit CUBIC_FOOT;
static { CUBIC_FOOT = null; }

/**
 * Constant for unit of volume: cubic-inch
 */

public static final android.icu.util.MeasureUnit CUBIC_INCH;
static { CUBIC_INCH = null; }

/**
 * Constant for unit of volume: cubic-kilometer
 */

public static final android.icu.util.MeasureUnit CUBIC_KILOMETER;
static { CUBIC_KILOMETER = null; }

/**
 * Constant for unit of volume: cubic-meter
 */

public static final android.icu.util.MeasureUnit CUBIC_METER;
static { CUBIC_METER = null; }

/**
 * Constant for unit of volume: cubic-mile
 */

public static final android.icu.util.MeasureUnit CUBIC_MILE;
static { CUBIC_MILE = null; }

/**
 * Constant for unit of volume: cubic-yard
 */

public static final android.icu.util.MeasureUnit CUBIC_YARD;
static { CUBIC_YARD = null; }

/**
 * Constant for unit of volume: cup
 */

public static final android.icu.util.MeasureUnit CUP;
static { CUP = null; }

/**
 * Constant for unit of volume: cup-metric
 */

public static final android.icu.util.MeasureUnit CUP_METRIC;
static { CUP_METRIC = null; }

/**
 * Constant for unit of duration: day
 */

public static final android.icu.util.TimeUnit DAY;
static { DAY = null; }

/**
 * Constant for unit of duration: decade
 */

public static final android.icu.util.MeasureUnit DECADE;
static { DECADE = null; }

/**
 * Constant for unit of volume: deciliter
 */

public static final android.icu.util.MeasureUnit DECILITER;
static { DECILITER = null; }

/**
 * Constant for unit of length: decimeter
 */

public static final android.icu.util.MeasureUnit DECIMETER;
static { DECIMETER = null; }

/**
 * Constant for unit of angle: degree
 */

public static final android.icu.util.MeasureUnit DEGREE;
static { DEGREE = null; }

/**
 * Constant for unit of graphics: dot
 */

public static final android.icu.util.MeasureUnit DOT;
static { DOT = null; }

/**
 * Constant for unit of graphics: dot-per-centimeter
 */

public static final android.icu.util.MeasureUnit DOT_PER_CENTIMETER;
static { DOT_PER_CENTIMETER = null; }

/**
 * Constant for unit of graphics: dot-per-inch
 */

public static final android.icu.util.MeasureUnit DOT_PER_INCH;
static { DOT_PER_INCH = null; }

/**
 * Constant for unit of graphics: em
 */

public static final android.icu.util.MeasureUnit EM;
static { EM = null; }

/**
 * Constant for unit of temperature: fahrenheit
 */

public static final android.icu.util.MeasureUnit FAHRENHEIT;
static { FAHRENHEIT = null; }

/**
 * Constant for unit of length: fathom
 */

public static final android.icu.util.MeasureUnit FATHOM;
static { FATHOM = null; }

/**
 * Constant for unit of volume: fluid-ounce
 */

public static final android.icu.util.MeasureUnit FLUID_OUNCE;
static { FLUID_OUNCE = null; }

/**
 * Constant for unit of energy: foodcalorie
 */

public static final android.icu.util.MeasureUnit FOODCALORIE;
static { FOODCALORIE = null; }

/**
 * Constant for unit of length: foot
 */

public static final android.icu.util.MeasureUnit FOOT;
static { FOOT = null; }

/**
 * Constant for unit of length: furlong
 */

public static final android.icu.util.MeasureUnit FURLONG;
static { FURLONG = null; }

/**
 * Constant for unit of volume: gallon
 */

public static final android.icu.util.MeasureUnit GALLON;
static { GALLON = null; }

/**
 * Constant for unit of volume: gallon-imperial
 */

public static final android.icu.util.MeasureUnit GALLON_IMPERIAL;
static { GALLON_IMPERIAL = null; }

/**
 * Constant for unit of pressure: gasoline-energy-density
 */

public static final android.icu.util.MeasureUnit GASOLINE_ENERGY_DENSITY;
static { GASOLINE_ENERGY_DENSITY = null; }

/**
 * Constant for unit of temperature: generic
 */

public static final android.icu.util.MeasureUnit GENERIC_TEMPERATURE;
static { GENERIC_TEMPERATURE = null; }

/**
 * Constant for unit of digital: gigabit
 */

public static final android.icu.util.MeasureUnit GIGABIT;
static { GIGABIT = null; }

/**
 * Constant for unit of digital: gigabyte
 */

public static final android.icu.util.MeasureUnit GIGABYTE;
static { GIGABYTE = null; }

/**
 * Constant for unit of frequency: gigahertz
 */

public static final android.icu.util.MeasureUnit GIGAHERTZ;
static { GIGAHERTZ = null; }

/**
 * Constant for unit of power: gigawatt
 */

public static final android.icu.util.MeasureUnit GIGAWATT;
static { GIGAWATT = null; }

/**
 * Constant for unit of mass: gram
 */

public static final android.icu.util.MeasureUnit GRAM;
static { GRAM = null; }

/**
 * Constant for unit of acceleration: g-force
 */

public static final android.icu.util.MeasureUnit G_FORCE;
static { G_FORCE = null; }

/**
 * Constant for unit of area: hectare
 */

public static final android.icu.util.MeasureUnit HECTARE;
static { HECTARE = null; }

/**
 * Constant for unit of volume: hectoliter
 */

public static final android.icu.util.MeasureUnit HECTOLITER;
static { HECTOLITER = null; }

/**
 * Constant for unit of pressure: hectopascal
 */

public static final android.icu.util.MeasureUnit HECTOPASCAL;
static { HECTOPASCAL = null; }

/**
 * Constant for unit of frequency: hertz
 */

public static final android.icu.util.MeasureUnit HERTZ;
static { HERTZ = null; }

/**
 * Constant for unit of power: horsepower
 */

public static final android.icu.util.MeasureUnit HORSEPOWER;
static { HORSEPOWER = null; }

/**
 * Constant for unit of duration: hour
 */

public static final android.icu.util.TimeUnit HOUR;
static { HOUR = null; }

/**
 * Constant for unit of length: inch
 */

public static final android.icu.util.MeasureUnit INCH;
static { INCH = null; }

/**
 * Constant for unit of pressure: inch-ofhg
 */

public static final android.icu.util.MeasureUnit INCH_HG;
static { INCH_HG = null; }

/**
 * Constant for unit of concentr: item
 */

public static final android.icu.util.MeasureUnit ITEM;
static { ITEM = null; }

/**
 * Constant for unit of energy: joule
 */

public static final android.icu.util.MeasureUnit JOULE;
static { JOULE = null; }

/**
 * Constant for unit of concentr: karat
 */

public static final android.icu.util.MeasureUnit KARAT;
static { KARAT = null; }

/**
 * Constant for unit of temperature: kelvin
 */

public static final android.icu.util.MeasureUnit KELVIN;
static { KELVIN = null; }

/**
 * Constant for unit of digital: kilobit
 */

public static final android.icu.util.MeasureUnit KILOBIT;
static { KILOBIT = null; }

/**
 * Constant for unit of digital: kilobyte
 */

public static final android.icu.util.MeasureUnit KILOBYTE;
static { KILOBYTE = null; }

/**
 * Constant for unit of energy: kilocalorie
 */

public static final android.icu.util.MeasureUnit KILOCALORIE;
static { KILOCALORIE = null; }

/**
 * Constant for unit of mass: kilogram
 */

public static final android.icu.util.MeasureUnit KILOGRAM;
static { KILOGRAM = null; }

/**
 * Constant for unit of frequency: kilohertz
 */

public static final android.icu.util.MeasureUnit KILOHERTZ;
static { KILOHERTZ = null; }

/**
 * Constant for unit of energy: kilojoule
 */

public static final android.icu.util.MeasureUnit KILOJOULE;
static { KILOJOULE = null; }

/**
 * Constant for unit of length: kilometer
 */

public static final android.icu.util.MeasureUnit KILOMETER;
static { KILOMETER = null; }

/**
 * Constant for unit of speed: kilometer-per-hour
 */

public static final android.icu.util.MeasureUnit KILOMETER_PER_HOUR;
static { KILOMETER_PER_HOUR = null; }

/**
 * Constant for unit of power: kilowatt
 */

public static final android.icu.util.MeasureUnit KILOWATT;
static { KILOWATT = null; }

/**
 * Constant for unit of energy: kilowatt-hour
 */

public static final android.icu.util.MeasureUnit KILOWATT_HOUR;
static { KILOWATT_HOUR = null; }

/**
 * Constant for unit of force: kilowatt-hour-per-100-kilometer
 */

public static final android.icu.util.MeasureUnit KILOWATT_HOUR_PER_100_KILOMETER;
static { KILOWATT_HOUR_PER_100_KILOMETER = null; }

/**
 * Constant for unit of speed: knot
 */

public static final android.icu.util.MeasureUnit KNOT;
static { KNOT = null; }

/**
 * Constant for unit of length: light-year
 */

public static final android.icu.util.MeasureUnit LIGHT_YEAR;
static { LIGHT_YEAR = null; }

/**
 * Constant for unit of volume: liter
 */

public static final android.icu.util.MeasureUnit LITER;
static { LITER = null; }

/**
 * Constant for unit of consumption: liter-per-100-kilometer
 */

public static final android.icu.util.MeasureUnit LITER_PER_100KILOMETERS;
static { LITER_PER_100KILOMETERS = null; }

/**
 * Constant for unit of consumption: liter-per-kilometer
 */

public static final android.icu.util.MeasureUnit LITER_PER_KILOMETER;
static { LITER_PER_KILOMETER = null; }

/**
 * Constant for unit of light: lumen
 */

public static final android.icu.util.MeasureUnit LUMEN;
static { LUMEN = null; }

/**
 * Constant for unit of light: lux
 */

public static final android.icu.util.MeasureUnit LUX;
static { LUX = null; }

/**
 * Constant for unit of digital: megabit
 */

public static final android.icu.util.MeasureUnit MEGABIT;
static { MEGABIT = null; }

/**
 * Constant for unit of digital: megabyte
 */

public static final android.icu.util.MeasureUnit MEGABYTE;
static { MEGABYTE = null; }

/**
 * Constant for unit of frequency: megahertz
 */

public static final android.icu.util.MeasureUnit MEGAHERTZ;
static { MEGAHERTZ = null; }

/**
 * Constant for unit of volume: megaliter
 */

public static final android.icu.util.MeasureUnit MEGALITER;
static { MEGALITER = null; }

/**
 * Constant for unit of graphics: megapixel
 */

public static final android.icu.util.MeasureUnit MEGAPIXEL;
static { MEGAPIXEL = null; }

/**
 * Constant for unit of power: megawatt
 */

public static final android.icu.util.MeasureUnit MEGAWATT;
static { MEGAWATT = null; }

/**
 * Constant for unit of length: meter
 */

public static final android.icu.util.MeasureUnit METER;
static { METER = null; }

/**
 * Constant for unit of speed: meter-per-second
 */

public static final android.icu.util.MeasureUnit METER_PER_SECOND;
static { METER_PER_SECOND = null; }

/**
 * Constant for unit of acceleration: meter-per-square-second
 */

public static final android.icu.util.MeasureUnit METER_PER_SECOND_SQUARED;
static { METER_PER_SECOND_SQUARED = null; }

/**
 * Constant for unit of mass: metric-ton (renamed to tonne in CLDR 42 / ICU 72).
 * Note: In ICU 74 this will be deprecated in favor of TONNE, which is currently
 * draft but will become stable in ICU 74, and which uses the preferred naming.
 */

public static final android.icu.util.MeasureUnit METRIC_TON;
static { METRIC_TON = null; }

/**
 * Constant for unit of mass: microgram
 */

public static final android.icu.util.MeasureUnit MICROGRAM;
static { MICROGRAM = null; }

/**
 * Constant for unit of length: micrometer
 */

public static final android.icu.util.MeasureUnit MICROMETER;
static { MICROMETER = null; }

/**
 * Constant for unit of duration: microsecond
 */

public static final android.icu.util.MeasureUnit MICROSECOND;
static { MICROSECOND = null; }

/**
 * Constant for unit of length: mile
 */

public static final android.icu.util.MeasureUnit MILE;
static { MILE = null; }

/**
 * Constant for unit of consumption: mile-per-gallon
 */

public static final android.icu.util.MeasureUnit MILE_PER_GALLON;
static { MILE_PER_GALLON = null; }

/**
 * Constant for unit of consumption: mile-per-gallon-imperial
 */

public static final android.icu.util.MeasureUnit MILE_PER_GALLON_IMPERIAL;
static { MILE_PER_GALLON_IMPERIAL = null; }

/**
 * Constant for unit of speed: mile-per-hour
 */

public static final android.icu.util.MeasureUnit MILE_PER_HOUR;
static { MILE_PER_HOUR = null; }

/**
 * Constant for unit of length: mile-scandinavian
 */

public static final android.icu.util.MeasureUnit MILE_SCANDINAVIAN;
static { MILE_SCANDINAVIAN = null; }

/**
 * Constant for unit of electric: milliampere
 */

public static final android.icu.util.MeasureUnit MILLIAMPERE;
static { MILLIAMPERE = null; }

/**
 * Constant for unit of pressure: millibar
 */

public static final android.icu.util.MeasureUnit MILLIBAR;
static { MILLIBAR = null; }

/**
 * Constant for unit of mass: milligram
 */

public static final android.icu.util.MeasureUnit MILLIGRAM;
static { MILLIGRAM = null; }

/**
 * Constant for unit of concentr: milligram-ofglucose-per-deciliter
 */

public static final android.icu.util.MeasureUnit MILLIGRAM_OFGLUCOSE_PER_DECILITER;
static { MILLIGRAM_OFGLUCOSE_PER_DECILITER = null; }

/**
 * Constant for unit of concentr: milligram-per-deciliter
 */

public static final android.icu.util.MeasureUnit MILLIGRAM_PER_DECILITER;
static { MILLIGRAM_PER_DECILITER = null; }

/**
 * Constant for unit of volume: milliliter
 */

public static final android.icu.util.MeasureUnit MILLILITER;
static { MILLILITER = null; }

/**
 * Constant for unit of length: millimeter
 */

public static final android.icu.util.MeasureUnit MILLIMETER;
static { MILLIMETER = null; }

/**
 * Constant for unit of pressure: millimeter-ofhg
 */

public static final android.icu.util.MeasureUnit MILLIMETER_OF_MERCURY;
static { MILLIMETER_OF_MERCURY = null; }

/**
 * Constant for unit of concentr: millimole-per-liter
 */

public static final android.icu.util.MeasureUnit MILLIMOLE_PER_LITER;
static { MILLIMOLE_PER_LITER = null; }

/**
 * Constant for unit of duration: millisecond
 */

public static final android.icu.util.MeasureUnit MILLISECOND;
static { MILLISECOND = null; }

/**
 * Constant for unit of power: milliwatt
 */

public static final android.icu.util.MeasureUnit MILLIWATT;
static { MILLIWATT = null; }

/**
 * Constant for unit of duration: minute
 */

public static final android.icu.util.TimeUnit MINUTE;
static { MINUTE = null; }

/**
 * Constant for unit of duration: month
 */

public static final android.icu.util.TimeUnit MONTH;
static { MONTH = null; }

/**
 * Constant for unit of length: nanometer
 */

public static final android.icu.util.MeasureUnit NANOMETER;
static { NANOMETER = null; }

/**
 * Constant for unit of duration: nanosecond
 */

public static final android.icu.util.MeasureUnit NANOSECOND;
static { NANOSECOND = null; }

/**
 * Constant for unit of length: nautical-mile
 */

public static final android.icu.util.MeasureUnit NAUTICAL_MILE;
static { NAUTICAL_MILE = null; }

/**
 * Constant for unit of electric: ohm
 */

public static final android.icu.util.MeasureUnit OHM;
static { OHM = null; }

/**
 * Constant for unit of mass: ounce
 */

public static final android.icu.util.MeasureUnit OUNCE;
static { OUNCE = null; }

/**
 * Constant for unit of mass: ounce-troy
 */

public static final android.icu.util.MeasureUnit OUNCE_TROY;
static { OUNCE_TROY = null; }

/**
 * Constant for unit of length: parsec
 */

public static final android.icu.util.MeasureUnit PARSEC;
static { PARSEC = null; }

/**
 * Constant for unit of concentr: permillion
 */

public static final android.icu.util.MeasureUnit PART_PER_MILLION;
static { PART_PER_MILLION = null; }

/**
 * Constant for unit of concentr: percent
 */

public static final android.icu.util.MeasureUnit PERCENT;
static { PERCENT = null; }

/**
 * Constant for unit of concentr: permille
 */

public static final android.icu.util.MeasureUnit PERMILLE;
static { PERMILLE = null; }

/**
 * Constant for unit of digital: petabyte
 */

public static final android.icu.util.MeasureUnit PETABYTE;
static { PETABYTE = null; }

/**
 * Constant for unit of length: picometer
 */

public static final android.icu.util.MeasureUnit PICOMETER;
static { PICOMETER = null; }

/**
 * Constant for unit of volume: pint
 */

public static final android.icu.util.MeasureUnit PINT;
static { PINT = null; }

/**
 * Constant for unit of volume: pint-metric
 */

public static final android.icu.util.MeasureUnit PINT_METRIC;
static { PINT_METRIC = null; }

/**
 * Constant for unit of graphics: pixel
 */

public static final android.icu.util.MeasureUnit PIXEL;
static { PIXEL = null; }

/**
 * Constant for unit of graphics: pixel-per-centimeter
 */

public static final android.icu.util.MeasureUnit PIXEL_PER_CENTIMETER;
static { PIXEL_PER_CENTIMETER = null; }

/**
 * Constant for unit of graphics: pixel-per-inch
 */

public static final android.icu.util.MeasureUnit PIXEL_PER_INCH;
static { PIXEL_PER_INCH = null; }

/**
 * Constant for unit of length: point
 */

public static final android.icu.util.MeasureUnit POINT;
static { POINT = null; }

/**
 * Constant for unit of mass: pound
 */

public static final android.icu.util.MeasureUnit POUND;
static { POUND = null; }

/**
 * Constant for unit of pressure: pound-force-per-square-inch
 */

public static final android.icu.util.MeasureUnit POUND_PER_SQUARE_INCH;
static { POUND_PER_SQUARE_INCH = null; }

/**
 * Constant for unit of volume: quart
 */

public static final android.icu.util.MeasureUnit QUART;
static { QUART = null; }

/**
 * Constant for unit of duration: quarter
 */

public static final android.icu.util.MeasureUnit QUARTER;
static { QUARTER = null; }

/**
 * Constant for unit of angle: radian
 */

public static final android.icu.util.MeasureUnit RADIAN;
static { RADIAN = null; }

/**
 * Constant for unit of angle: revolution
 */

public static final android.icu.util.MeasureUnit REVOLUTION_ANGLE;
static { REVOLUTION_ANGLE = null; }

/**
 * Constant for unit of duration: second
 */

public static final android.icu.util.TimeUnit SECOND;
static { SECOND = null; }

/**
 * Constant for unit of area: square-centimeter
 */

public static final android.icu.util.MeasureUnit SQUARE_CENTIMETER;
static { SQUARE_CENTIMETER = null; }

/**
 * Constant for unit of area: square-foot
 */

public static final android.icu.util.MeasureUnit SQUARE_FOOT;
static { SQUARE_FOOT = null; }

/**
 * Constant for unit of area: square-inch
 */

public static final android.icu.util.MeasureUnit SQUARE_INCH;
static { SQUARE_INCH = null; }

/**
 * Constant for unit of area: square-kilometer
 */

public static final android.icu.util.MeasureUnit SQUARE_KILOMETER;
static { SQUARE_KILOMETER = null; }

/**
 * Constant for unit of area: square-meter
 */

public static final android.icu.util.MeasureUnit SQUARE_METER;
static { SQUARE_METER = null; }

/**
 * Constant for unit of area: square-mile
 */

public static final android.icu.util.MeasureUnit SQUARE_MILE;
static { SQUARE_MILE = null; }

/**
 * Constant for unit of area: square-yard
 */

public static final android.icu.util.MeasureUnit SQUARE_YARD;
static { SQUARE_YARD = null; }

/**
 * Constant for unit of mass: stone
 */

public static final android.icu.util.MeasureUnit STONE;
static { STONE = null; }

/**
 * Constant for unit of volume: tablespoon
 */

public static final android.icu.util.MeasureUnit TABLESPOON;
static { TABLESPOON = null; }

/**
 * Constant for unit of volume: teaspoon
 */

public static final android.icu.util.MeasureUnit TEASPOON;
static { TEASPOON = null; }

/**
 * Constant for unit of digital: terabit
 */

public static final android.icu.util.MeasureUnit TERABIT;
static { TERABIT = null; }

/**
 * Constant for unit of digital: terabyte
 */

public static final android.icu.util.MeasureUnit TERABYTE;
static { TERABYTE = null; }

/**
 * Constant for unit of mass: ton
 */

public static final android.icu.util.MeasureUnit TON;
static { TON = null; }

/**
 * Constant for unit of mass: tonne
 */

public static final android.icu.util.MeasureUnit TONNE;
static { TONNE = null; }

/**
 * Constant for unit of electric: volt
 */

public static final android.icu.util.MeasureUnit VOLT;
static { VOLT = null; }

/**
 * Constant for unit of power: watt
 */

public static final android.icu.util.MeasureUnit WATT;
static { WATT = null; }

/**
 * Constant for unit of duration: week
 */

public static final android.icu.util.TimeUnit WEEK;
static { WEEK = null; }

/**
 * Constant for unit of length: yard
 */

public static final android.icu.util.MeasureUnit YARD;
static { YARD = null; }

/**
 * Constant for unit of duration: year
 */

public static final android.icu.util.TimeUnit YEAR;
static { YEAR = null; }
/**
 * Enumeration for unit complexity. There are three levels:
 * <ul>
 * <li>SINGLE: A single unit, optionally with a power and/or SI or binary prefix.
 * Examples: hectare, square-kilometer, kilojoule, per-second, mebibyte.</li>
 * <li>COMPOUND: A unit composed of the product of multiple single units. Examples:
 * meter-per-second, kilowatt-hour, kilogram-meter-per-square-second.</li>
 * <li>MIXED: A unit composed of the sum of multiple single units. Examples: foot-and-inch,
 * hour-and-minute-and-second, degree-and-arcminute-and-arcsecond.</li>
 * </ul>
 * The complexity determines which operations are available. For example, you cannot set the power
 * or prefix of a compound unit.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Complexity {
/**
 * A compound unit, like meter-per-second.
 */

COMPOUND,
/**
 * A mixed unit, like hour-and-minute.
 */

MIXED,
/**
 * A single unit, like kilojoule.
 */

SINGLE;
}

/**
 * Enumeration for SI and binary prefixes, e.g. "kilo-", "nano-", "mebi-".
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum MeasurePrefix {
/**
 * SI prefix: atto, 10^-18.
 */

ATTO,
/**
 * SI prefix: centi, 10^-2.
 */

CENTI,
/**
 * SI prefix: deci, 10^-1.
 */

DECI,
/**
 * SI prefix: deka, 10^1.
 */

DEKA,
/**
 * SI prefix: exa, 10^18.
 */

EXA,
/**
 * IEC binary prefix: exbi, 1024^6.
 */

EXBI,
/**
 * SI prefix: femto, 10^-15.
 */

FEMTO,
/**
 * IEC binary prefix: gibi, 1024^3.
 */

GIBI,
/**
 * SI prefix: giga, 10^9.
 */

GIGA,
/**
 * SI prefix: hecto, 10^2.
 */

HECTO,
/**
 * IEC binary prefix: kibi, 1024^1.
 */

KIBI,
/**
 * SI prefix: kilo, 10^3.
 */

KILO,
/**
 * IEC binary prefix: mebi, 1024^2.
 */

MEBI,
/**
 * SI prefix: mega, 10^6.
 */

MEGA,
/**
 * SI prefix: micro, 10^-6.
 */

MICRO,
/**
 * SI prefix: milli, 10^-3.
 */

MILLI,
/**
 * SI prefix: nano, 10^-9.
 */

NANO,
/**
 * The absence of an SI prefix.
 */

ONE,
/**
 * IEC binary prefix: pebi, 1024^5.
 */

PEBI,
/**
 * SI prefix: peta, 10^15.
 */

PETA,
/**
 * SI prefix: pico, 10^-12.
 */

PICO,
/**
 * IEC binary prefix: tebi, 1024^4.
 */

TEBI,
/**
 * SI prefix: tera, 10^12.
 */

TERA,
/**
 * IEC binary prefix: yobi, 1024^8.
 */

YOBI,
/**
 * SI prefix: yocto, 10^-24.
 */

YOCTO,
/**
 * SI prefix: yotta, 10^24.
 */

YOTTA,
/**
 * IEC binary prefix: zebi, 1024^7.
 */

ZEBI,
/**
 * SI prefix: zepto, 10^-21.
 */

ZEPTO,
/**
 * SI prefix: zetta, 10^21.
 */

ZETTA;

/**
 * Returns the base of the prefix. For example:
 * - if the prefix is "centi", the base will be 10.
 * - if the prefix is "gibi", the base will be 1024.
 */

public int getBase() { throw new RuntimeException("Stub!"); }

/**
 * Returns the power of the prefix. For example:
 * - if the prefix is "centi", the power will be -2.
 * - if the prefix is "gibi", the power will be 3 (for base 1024).
 */

public int getPower() { throw new RuntimeException("Stub!"); }
}

}

