/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;

/** Captures the user's steps cadence. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class StepsCadenceRecord extends android.health.connect.datatypes.IntervalRecord {

StepsCadenceRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * @return StepsCadenceRecord samples corresponding to this record

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.StepsCadenceRecord.StepsCadenceRecordSample> getSamples() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to retrieve average Steps cadence rate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Double> STEPS_CADENCE_RATE_AVG;
static { STEPS_CADENCE_RATE_AVG = null; }

/**
 * Metric identifier to retrieve maximum Steps cadence rate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Double> STEPS_CADENCE_RATE_MAX;
static { STEPS_CADENCE_RATE_MAX = null; }

/**
 * Metric identifier to retrieve minimum Steps cadence rate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Double> STEPS_CADENCE_RATE_MIN;
static { STEPS_CADENCE_RATE_MIN = null; }
/** Builder class for {@link android.health.connect.datatypes.StepsCadenceRecord StepsCadenceRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity
 * This value cannot be {@code null}.
 * @param stepsCadenceRecordSamples Samples of recorded StepsCadenceRecord

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, @android.annotation.NonNull java.util.List<android.health.connect.datatypes.StepsCadenceRecord.StepsCadenceRecordSample> stepsCadenceRecordSamples) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.StepsCadenceRecord StepsCadenceRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.StepsCadenceRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.StepsCadenceRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.StepsCadenceRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.StepsCadenceRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.StepsCadenceRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }
}

/** Represents a single measurement of the steps cadence. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StepsCadenceRecordSample {

/**
 * StepsCadenceRecord sample for entries of {@link android.health.connect.datatypes.StepsCadenceRecord StepsCadenceRecord}
 *
 * @param rate Rate in steps per minute.
 * @param time The point in time when the measurement was taken.

 * This value cannot be {@code null}.
 */

public StepsCadenceRecordSample(double rate, @android.annotation.NonNull java.time.Instant time) { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * @return Rate for this sample
 */

public double getRate() { throw new RuntimeException("Stub!"); }

/**
 * @return time at which this sample was recorded

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

