/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * Captures a planned exercise session, also commonly referred to as a training plan.
 *
 * <p>Each record contains a start time, end time, an exercise type and a list of {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock} which describe the details of the planned session. The start and end times
 * may be in the future.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlannedExerciseSessionRecord extends android.health.connect.datatypes.IntervalRecord {

PlannedExerciseSessionRecord() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the exercise blocks for this step.
 *
 * @return An unmodifiable list of {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.PlannedExerciseBlock> getBlocks() { throw new RuntimeException("Stub!"); }

/**
 * Returns the id of exercise session that completed this planned session. Returns null if none
 * exists.
 */

@android.annotation.Nullable
public java.lang.String getCompletedExerciseSessionId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the expected duration of the planned session.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getDuration() { throw new RuntimeException("Stub!"); }

/**
 * Returns the exercise type of this planned session.
 * @return Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 */

public int getExerciseType() { throw new RuntimeException("Stub!"); }

/** Returns notes for this planned session. Returns null if it doesn't have notes. */

@android.annotation.Nullable
public java.lang.CharSequence getNotes() { throw new RuntimeException("Stub!"); }

/**
 * Returns the start date of the planned session.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.LocalDate getStartDate() { throw new RuntimeException("Stub!"); }

/** Returns title of this planned session. Returns null if it doesn't have a title. */

@android.annotation.Nullable
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether this planned session has an explicit time. If only a date was provided this
 * will be false.
 */

public boolean hasExplicitTime() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.PlannedExerciseSessionRecord PlannedExerciseSessionRecord}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param exerciseType Type of exercise (e.g. walking, swimming). Allowed values: {@link android.health.connect.datatypes.ExerciseSessionType ExerciseSessionType}.
 * Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 * @param startTime Expected start time of this planned session.
 * This value cannot be {@code null}.
 * @param endTime Expected end time of this planned session.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, int exerciseType, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param exerciseType Type of exercise (e.g. walking, swimming). Required field. Allowed
 *     values: {@link android.health.connect.datatypes.ExerciseSessionType ExerciseSessionType}.
 * Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 * @param startDate The start date of this planned session. The underlying time of the
 *     session will be set to noon of the specified day. The end time will be determined by
 *     adding the duration to this.
 * This value cannot be {@code null}.
 * @param duration The expected duration of the planned session.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, int exerciseType, @android.annotation.NonNull java.time.LocalDate startDate, @android.annotation.NonNull java.time.Duration duration) { throw new RuntimeException("Stub!"); }

/**
 * Adds a block to this planned session..
 *
 * @param block An {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock} to add to this planned session..
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder addBlock(@android.annotation.NonNull android.health.connect.datatypes.PlannedExerciseBlock block) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.health.connect.datatypes.PlannedExerciseSessionRecord PlannedExerciseSessionRecord}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Clears the blocks of this planned session.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder clearBlocks() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the blocks of this planned session.
 *
 * @param blocks A list of {@link android.health.connect.datatypes.PlannedExerciseBlock PlannedExerciseBlock} to set for this planned session.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setBlocks(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.PlannedExerciseBlock> blocks) { throw new RuntimeException("Stub!"); }

/**
 * Sets the planned end time of the session.
 * @param endTime This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setEndTime(@android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of when the workout should end.
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the exercise type.
 * @param exerciseType Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setExerciseType(int exerciseType) { throw new RuntimeException("Stub!"); }

/**
 * Set the metadata for the record.
 * @param metadata This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setMetadata(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata) { throw new RuntimeException("Stub!"); }

/**
 * Sets notes for this activity.
 *
 * @param notes Notes for this activity.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setNotes(@android.annotation.Nullable java.lang.CharSequence notes) { throw new RuntimeException("Stub!"); }

/**
 * Sets the planned start time of the session.
 * @param startTime This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setStartTime(@android.annotation.NonNull java.time.Instant startTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of when the workout should start.
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets a title of this planned session.
 *
 * @param title Title of this activity.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PlannedExerciseSessionRecord.Builder setTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }
}

}

