/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.datatypes.units.BloodGlucose;

/**
 * Captures the concentration of glucose in the blood. Each record represents a single instantaneous
 * blood glucose reading.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BloodGlucoseRecord extends android.health.connect.datatypes.InstantRecord {

BloodGlucoseRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return level

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.BloodGlucose getLevel() { throw new RuntimeException("Stub!"); }

/**
 * @return mealType

 * Value is {@link android.health.connect.datatypes.MealType#MEAL_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_BREAKFAST}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_LUNCH}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_DINNER}, or {@link android.health.connect.datatypes.MealType#MEAL_TYPE_SNACK}
 */

public int getMealType() { throw new RuntimeException("Stub!"); }

/**
 * @return relationToMeal

 * Value is {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_UNKNOWN}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_GENERAL}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_FASTING}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_BEFORE_MEAL}, or {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_AFTER_MEAL}
 */

public int getRelationToMeal() { throw new RuntimeException("Stub!"); }

/**
 * @return specimenSource

 * Value is {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_UNKNOWN}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_INTERSTITIAL_FLUID}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_CAPILLARY_BLOOD}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_PLASMA}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_SERUM}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_TEARS}, or {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_WHOLE_BLOOD}
 */

public int getSpecimenSource() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.BloodGlucoseRecord BloodGlucoseRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param specimenSource Type of body fluid used to measure the blood glucose. Optional,
 *     enum field. Allowed values: {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource SpecimenSource}.
 * Value is {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_UNKNOWN}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_INTERSTITIAL_FLUID}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_CAPILLARY_BLOOD}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_PLASMA}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_SERUM}, {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_TEARS}, or {@link android.health.connect.datatypes.BloodGlucoseRecord.SpecimenSource#SPECIMEN_SOURCE_WHOLE_BLOOD}
 * @param level Blood glucose level or concentration in {@link android.health.connect.datatypes.units.BloodGlucose BloodGlucose} unit. Required
 *     field. Valid range: 0-50 mmol/L.
 * This value cannot be {@code null}.
 * @param relationToMeal Relationship of the meal to the blood glucose measurement.
 *     Optional, enum field. Allowed values: {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType RelationToMealType}.
 * Value is {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_UNKNOWN}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_GENERAL}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_FASTING}, {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_BEFORE_MEAL}, or {@link android.health.connect.datatypes.BloodGlucoseRecord.RelationToMealType#RELATION_TO_MEAL_AFTER_MEAL}
 * @param mealType Type of meal related to the blood glucose measurement. Optional, enum
 *     field. Allowed values: {@link android.health.connect.datatypes.MealType MealType}.

 * Value is {@link android.health.connect.datatypes.MealType#MEAL_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_BREAKFAST}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_LUNCH}, {@link android.health.connect.datatypes.MealType#MEAL_TYPE_DINNER}, or {@link android.health.connect.datatypes.MealType#MEAL_TYPE_SNACK}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int specimenSource, @android.annotation.NonNull android.health.connect.datatypes.units.BloodGlucose level, int relationToMeal, int mealType) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.BloodGlucoseRecord BloodGlucoseRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodGlucoseRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodGlucoseRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodGlucoseRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }
}

/** Relationship of the meal to the blood glucose measurement. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RelationToMealType {

RelationToMealType() { throw new RuntimeException("Stub!"); }

/** Reading was taken after an unspecified meal. */

public static final int RELATION_TO_MEAL_AFTER_MEAL = 4; // 0x4

/** Reading was taken before an unspecified meal. */

public static final int RELATION_TO_MEAL_BEFORE_MEAL = 3; // 0x3

/** Reading was taken during a fasting period. */

public static final int RELATION_TO_MEAL_FASTING = 2; // 0x2

/** Reading was not taken immediately before or after eating. */

public static final int RELATION_TO_MEAL_GENERAL = 1; // 0x1

/** Represents a blood glucose which relationship to any meal is unknown / not defined. */

public static final int RELATION_TO_MEAL_UNKNOWN = 0; // 0x0
}

/** Type of body fluid used to measure the blood glucose. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SpecimenSource {

SpecimenSource() { throw new RuntimeException("Stub!"); }

/** Glucose was measured in capillary blood. */

public static final int SPECIMEN_SOURCE_CAPILLARY_BLOOD = 2; // 0x2

/** Glucose was measured in interstitial fluid. */

public static final int SPECIMEN_SOURCE_INTERSTITIAL_FLUID = 1; // 0x1

/** Glucose was measured in plasma. */

public static final int SPECIMEN_SOURCE_PLASMA = 3; // 0x3

/** Glucose was measured in serum. */

public static final int SPECIMEN_SOURCE_SERUM = 4; // 0x4

/** Glucose was measured in tears. */

public static final int SPECIMEN_SOURCE_TEARS = 5; // 0x5

/** Fluid used to measure glucose is not identified. */

public static final int SPECIMEN_SOURCE_UNKNOWN = 0; // 0x0

/** Glucose was measured from whole blood. */

public static final int SPECIMEN_SOURCE_WHOLE_BLOOD = 6; // 0x6
}

}

