/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models;

import android.graphics.Rect;

/**
 * Information about a form widget of a PDF document.
 *
 * @see <a
 * href="https://opensource.adobe.com/dc-acrobat-sdk-docs/pdfstandards/PDF32000_2008.pdf">PDF
 * 32000-1:2008</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FormWidgetInfo implements android.os.Parcelable {

FormWidgetInfo() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Returns the field's accessibility label, if present
 *
 * <p><strong>Note:</strong> Comes from the "TU" value in the annotation dictionary, if present,
 * or else the "T" value. See PDF Spec 1.7 Table 8.69

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getAccessibilityLabel() { throw new RuntimeException("Stub!"); }

/**
 * Returns the font size in pixels for text input, or 0 for text inputs without a specified font
 * size and widgets that are not text inputs.

 * @return Value is 0f or greater
 */

public float getFontSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of choice options in the order that it was passed in, or an empty list for
 * widgets without choice options.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.models.ListItem> getListItems() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum length of text supported by a text input widget, or -1 for text inputs
 * without a maximum length and widgets that are not text inputs.

 * @return Value is -1 or greater
 */

public int getMaxLength() { throw new RuntimeException("Stub!"); }

/**
 * Returns the field's text value, if present
 *
 * <p><strong>Note:</strong> Comes from the "V" value in the annotation dictionary. See <a
 * href="https://opensource.adobe.com/dc-acrobat-sdk-docs/pdfstandards/pdfreference1.7old
 * .pdf">PDF
 * Spec 1.7 Table 8.69</a>
 * Table 8.69

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getTextValue() { throw new RuntimeException("Stub!"); }

/**
 * Returns the index of the widget within the page's "Annot" array in the PDF document
 * @return Value is 0 or greater
 */

public int getWidgetIndex() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.graphics.Rect Rect} in page coordinates occupied by the widget

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.Rect getWidgetRect() { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of this widget
 * @return Value is {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_UNKNOWN}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_PUSHBUTTON}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_CHECKBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_RADIOBUTTON}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_COMBOBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_LISTBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_TEXTFIELD}, or {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_SIGNATURE}
 */

public int getWidgetType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Returns {@code true} if the widget is editable text */

public boolean isEditableText() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the widget supports multiple lines of text input
 */

public boolean isMultiLineText() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the widget supports selecting multiple values
 */

public boolean isMultiSelect() { throw new RuntimeException("Stub!"); }

/** Returns {@code true} if the widget is read-only */

public boolean isReadOnly() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.FormWidgetInfo> CREATOR;
static { CREATOR = null; }

/** Represents a checkbox type form widget */

public static final int WIDGET_TYPE_CHECKBOX = 2; // 0x2

/** Represents a combobox type form widget */

public static final int WIDGET_TYPE_COMBOBOX = 4; // 0x4

/** Represents a listbox type form widget */

public static final int WIDGET_TYPE_LISTBOX = 5; // 0x5

/** Represents a push button type form widget */

public static final int WIDGET_TYPE_PUSHBUTTON = 1; // 0x1

/** Represents a radio button type form widget */

public static final int WIDGET_TYPE_RADIOBUTTON = 3; // 0x3

/** Represents a signature type form widget */

public static final int WIDGET_TYPE_SIGNATURE = 7; // 0x7

/** Represents a text field type form widget */

public static final int WIDGET_TYPE_TEXTFIELD = 6; // 0x6

/** Represents a form widget type that is unknown */

public static final int WIDGET_TYPE_UNKNOWN = 0; // 0x0
/** Builder for {@link android.graphics.pdf.models.FormWidgetInfo FormWidgetInfo} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates an instance
 *
 * @param widgetType         the type of widget
 * Value is {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_UNKNOWN}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_PUSHBUTTON}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_CHECKBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_RADIOBUTTON}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_COMBOBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_LISTBOX}, {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_TEXTFIELD}, or {@link android.graphics.pdf.models.FormWidgetInfo#WIDGET_TYPE_SIGNATURE}
 * @param widgetIndex        the index of the widget in the page's "Annot" array in the PDF
 * Value is 0 or greater
 * @param widgetRect         the {@link android.graphics.Rect Rect} in page coordinates occupied by the widget
 * This value cannot be {@code null}.
 * @param textValue          the widget's text value
 * This value cannot be {@code null}.
 * @param accessibilityLabel the field's accessibility label
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException if any of {@code widgetRect}, {@code textValue}, or {@code
 *                              accessibilityLabel} are null
 */

public Builder(int widgetType, int widgetIndex, @android.annotation.NonNull android.graphics.Rect widgetRect, @android.annotation.NonNull java.lang.String textValue, @android.annotation.NonNull java.lang.String accessibilityLabel) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.graphics.pdf.models.FormWidgetInfo FormWidgetInfo}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether this widget contains editable text. Only supported for comboboxes and
 * text fields
 *
 * @throws java.lang.IllegalArgumentException if this is not a combobox or text field type widget

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setEditableText(boolean editableText) { throw new RuntimeException("Stub!"); }

/**
 * Sets the font size for this widget. Only supported for text fields and comboboxes
 *
 * @throws java.lang.IllegalArgumentException if this is not a combobox or text field, or if a
 *                                  negative font size is supplied
 
 * @param fontSize Value is 0f or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setFontSize(float fontSize) { throw new RuntimeException("Stub!"); }

/**
 * Sets the choice options for this widget. Only supported for comboboxes and list boxes
 *
 * @throws java.lang.IllegalArgumentException if this is not a combobox or list box
 * @throws java.lang.NullPointerException     if {@code choiceOptions} is null
 
 * @param listItems This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setListItems(@android.annotation.NonNull java.util.List<android.graphics.pdf.models.ListItem> listItems) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum character length of input text supported by this widget. Only supported
 * for text fields
 *
 * @throws java.lang.IllegalArgumentException if this is not a text field, or if a negative max length
 *                                  is supplied
 
 * @param maxLength Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setMaxLength(int maxLength) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether this widget supports multi-line text input. Only supported for text fields
 *
 * @throws java.lang.IllegalArgumentException if this is not a text field

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setMultiLineText(boolean multiLineText) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether this widget supports multiple choice selections. Only supported for
 * list boxes
 *
 * @throws java.lang.IllegalArgumentException if this is not a list box

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setMultiSelect(boolean multiSelect) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether this widget is read-only
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo.Builder setReadOnly(boolean readOnly) { throw new RuntimeException("Stub!"); }
}

}

