/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.database.sqlite;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SQLiteRawStatement implements java.io.Closeable {

SQLiteRawStatement() { throw new RuntimeException("Stub!"); }

public void bindBlob(int parameterIndex, @android.annotation.NonNull byte[] value) { throw new RuntimeException("Stub!"); }

public void bindBlob(int parameterIndex, @android.annotation.NonNull byte[] value, int offset, int length) { throw new RuntimeException("Stub!"); }

public void bindDouble(int parameterIndex, double value) { throw new RuntimeException("Stub!"); }

public void bindInt(int parameterIndex, int value) { throw new RuntimeException("Stub!"); }

public void bindLong(int parameterIndex, long value) { throw new RuntimeException("Stub!"); }

public void bindNull(int parameterIndex) { throw new RuntimeException("Stub!"); }

public void bindText(int parameterIndex, @android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

public void clearBindings() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getColumnBlob(int columnIndex) { throw new RuntimeException("Stub!"); }

public double getColumnDouble(int columnIndex) { throw new RuntimeException("Stub!"); }

public int getColumnInt(int columnIndex) { throw new RuntimeException("Stub!"); }

public int getColumnLength(int columnIndex) { throw new RuntimeException("Stub!"); }

public long getColumnLong(int columnIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getColumnName(int columnIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getColumnText(int columnIndex) { throw new RuntimeException("Stub!"); }

public int getColumnType(int columnIndex) { throw new RuntimeException("Stub!"); }

public int getParameterCount() { throw new RuntimeException("Stub!"); }

public int getParameterIndex(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getParameterName(int parameterIndex) { throw new RuntimeException("Stub!"); }

public int getResultColumnCount() { throw new RuntimeException("Stub!"); }

public boolean isOpen() { throw new RuntimeException("Stub!"); }

public int readColumnBlob(int columnIndex, @android.annotation.NonNull byte[] buffer, int offset, int length, int srcOffset) { throw new RuntimeException("Stub!"); }

public void reset() { throw new RuntimeException("Stub!"); }

public boolean step() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int SQLITE_DATA_TYPE_BLOB = 4; // 0x4

public static final int SQLITE_DATA_TYPE_FLOAT = 2; // 0x2

public static final int SQLITE_DATA_TYPE_INTEGER = 1; // 0x1

public static final int SQLITE_DATA_TYPE_NULL = 5; // 0x5

public static final int SQLITE_DATA_TYPE_TEXT = 3; // 0x3
}

