/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * Embeddings are vector representations of data, such as text, images, and audio, which can be
 * generated by machine learning models and used for semantic search. This class represents an
 * embedding vector, which wraps a float array for the values of the embedding vector and a model
 * signature that can be any string to distinguish between embedding vectors generated by different
 * models.
 *
 * <p>For more details on how embedding search works, check {@link android.app.appsearch.AppSearchSession#search AppSearchSession.search} and
 * {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String) SearchSpec.Builder.setRankingStrategy(String)}.
 *
 * @see SearchSpec.Builder#addEmbeddingParameters
 * @see android.app.appsearch.GenericDocument.Builder#setPropertyEmbedding
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EmbeddingVector implements android.os.Parcelable {

/**
 * Creates a new {@link android.app.appsearch.EmbeddingVector EmbeddingVector}.
 *
 * @throws java.lang.IllegalArgumentException if {@code values} is empty.
 
 * @param values This value cannot be {@code null}.

 * @param modelSignature This value cannot be {@code null}.
 */

public EmbeddingVector(@android.annotation.NonNull float[] values, @android.annotation.NonNull java.lang.String modelSignature) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the model signature of this embedding vector, which is an arbitrary string to
 * distinguish between embedding vectors generated by different models.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getModelSignature() { throw new RuntimeException("Stub!"); }

/**
 * Returns the values of this embedding vector.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public float[] getValues() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.EmbeddingVector> CREATOR;
static { CREATOR = null; }
}

