/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.net.NetworkCapabilities;
import android.telephony.TelephonyManager;

/**
 * User data provided by the platform to an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UserData implements android.os.Parcelable {

UserData() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * A map from package name to app information for installed and uninstalled apps.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,android.adservices.ondevicepersonalization.AppInfo> getAppInfos() { throw new RuntimeException("Stub!"); }

/**
 * The available space on device in bytes.

 * @return Value is 0 or greater
 */

public long getAvailableStorageBytes() { throw new RuntimeException("Stub!"); }

/**
 * Battery percentage.

 * @return Value is between 0 and 100 inclusive
 */

public int getBatteryPercentage() { throw new RuntimeException("Stub!"); }

/**
 * The Service Provider Name (SPN) returned by {@link android.telephony.TelephonyManager#getSimOperatorName() TelephonyManager.getSimOperatorName()}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getCarrier() { throw new RuntimeException("Stub!"); }

/**
 * Data network type. This is the value of
 * {@link android.telephony.TelephonyManager#getDataNetworkType()}.

 * @return Value is {@link android.telephony.TelephonyManager#NETWORK_TYPE_UNKNOWN}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_GPRS}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_EDGE}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_UMTS}, android.telephony.TelephonyManager.NETWORK_TYPE_CDMA, android.telephony.TelephonyManager.NETWORK_TYPE_EVDO_0, android.telephony.TelephonyManager.NETWORK_TYPE_EVDO_A, android.telephony.TelephonyManager.NETWORK_TYPE_1xRTT, {@link android.telephony.TelephonyManager#NETWORK_TYPE_HSDPA}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_HSUPA}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_HSPA}, android.telephony.TelephonyManager.NETWORK_TYPE_EVDO_B, {@link android.telephony.TelephonyManager#NETWORK_TYPE_LTE}, android.telephony.TelephonyManager.NETWORK_TYPE_EHRPD, {@link android.telephony.TelephonyManager#NETWORK_TYPE_HSPAP}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_GSM}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_TD_SCDMA}, {@link android.telephony.TelephonyManager#NETWORK_TYPE_IWLAN}, or {@link android.telephony.TelephonyManager#NETWORK_TYPE_NR}
 */

public int getDataNetworkType() { throw new RuntimeException("Stub!"); }

/**
 * A filtered subset of the Network capabilities of the device that contains upstream
 * and downstream speeds, and whether the network is metered.
 * This is an instance of {@link android.net.NetworkCapabilities NetworkCapabilities} that contains the capability
 * {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED} if the network is not
 * metered, and {@link android.net.NetworkCapabilities#getLinkDownstreamBandwidthKbps() NetworkCapabilities.getLinkDownstreamBandwidthKbps()} and
 * {@link android.net.NetworkCapabilities#getLinkUpstreamBandwidthKbps() NetworkCapabilities.getLinkUpstreamBandwidthKbps()} return the downstream and
 * upstream connection speeds. All other methods of this {@link android.net.NetworkCapabilities NetworkCapabilities} object
 * return empty or default values.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.NetworkCapabilities getNetworkCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * The device orientation. The value can be one of the constants ORIENTATION_UNDEFINED,
 * ORIENTATION_PORTRAIT or ORIENTATION_LANDSCAPE defined in
 * {@link android.content.res.Configuration}.

 * @return Value is {@link android.content.res.Configuration#ORIENTATION_UNDEFINED}, {@link android.content.res.Configuration#ORIENTATION_PORTRAIT}, or {@link android.content.res.Configuration#ORIENTATION_LANDSCAPE}
 */

public int getOrientation() { throw new RuntimeException("Stub!"); }

/**
 * The device timezone +/- offset from UTC.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getTimezoneUtcOffset() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.ondevicepersonalization.UserData> CREATOR;
static { CREATOR = null; }
}

