/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import java.util.List;

/**
 * An interface to a read logs from REQUESTS and EVENTS
 *
 * Used as a Data Access Object for the REQUESTS and EVENTS table.
 *
 * @see android.adservices.ondevicepersonalization.IsolatedService#getLogReader(RequestToken)
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class LogReader {

LogReader() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a List of EventLogRecord with its corresponding RequestLogRecord written by this
 * IsolatedService within the specified time range.
 
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 
 * @param startTime This value cannot be {@code null}.
 * @param endTime This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> getJoinedEvents(@android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a List of RequestLogRecords written by this IsolatedService within
 * the specified time range.
 
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 
 * @param startTime This value cannot be {@code null}.
 * @param endTime This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.ondevicepersonalization.RequestLogRecord> getRequests(@android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }
}

