/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

import android.net.Uri;

/** Class holding source registration parameters. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WebSourceParams implements android.os.Parcelable {

WebSourceParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Getter for registration Uri.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getRegistrationUri() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Getter for debug allowed/disallowed flag. Its value as {@code true} means to allow parsing
 * debug keys from registration responses and their addition in the generated reports.
 */

public boolean isDebugKeyAllowed() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/** Creator for Paracelable (via reflection). */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.measurement.WebSourceParams> CREATOR;
static { CREATOR = null; }
/** A builder for {@link android.adservices.measurement.WebSourceParams WebSourceParams}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Builder constructor for {@link android.adservices.measurement.WebSourceParams WebSourceParams}. {@code mIsDebugKeyAllowed} is assigned
 * false by default.
 *
 * @param registrationUri URI that the Attribution Reporting API sends a request to in order
 *     to obtain source registration parameters.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the scheme for {@code registrationUri} is not HTTPS
 */

public Builder(@android.annotation.NonNull android.net.Uri registrationUri) { throw new RuntimeException("Stub!"); }

/**
 * Built immutable {@link android.adservices.measurement.WebSourceParams WebSourceParams}.
 *
 * @return immutable {@link android.adservices.measurement.WebSourceParams WebSourceParams}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceParams build() { throw new RuntimeException("Stub!"); }

/**
 * Setter for debug allow/disallow flag. Setting it to true will allow parsing debug keys
 * from registration responses and their addition in the generated reports.
 *
 * @param debugKeyAllowed used by the browser to indicate whether the debug key obtained
 *     from the registration URI is allowed to be used
 * @return builder

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceParams.Builder setDebugKeyAllowed(boolean debugKeyAllowed) { throw new RuntimeException("Stub!"); }
}

}

