/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * Represent input parameters to the reportImpression API.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ReportImpressionRequest {

/**
 * Ctor for auction server ad selection reporting request.
 *
 * <p>If your {@code adSelectionId} is for a server auction run where device info collected by
 * {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData AdSelectionManager.getAdSelectionData} then your impression reporting request should
 * only include the ad selection id.
 *
 * <p>{@link android.adservices.adselection.AdSelectionManager#persistAdSelectionResult AdSelectionManager.persistAdSelectionResult} must be called with the encrypted
 * result blob from servers before making impression reporting request.
 *
 * @param adSelectionId received from {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData AdSelectionManager.getAdSelectionData}
 */

public ReportImpressionRequest(long adSelectionId) { throw new RuntimeException("Stub!"); }

/**
 * Ctor for on-device ad selection reporting request.
 *
 * <p>If your {@code adSelectionId} is for a on-device auction run using {@link android.adservices.adselection.AdSelectionManager#selectAds(android.adservices.adselection.AdSelectionConfig,java.util.concurrent.Executor,android.os.OutcomeReceiver)  } then your
 * impression reporting request must include your {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig}.
 *
 * @param adSelectionId received from {@link android.adservices.adselection.AdSelectionManager#selectAds(android.adservices.adselection.AdSelectionConfig,java.util.concurrent.Executor,android.os.OutcomeReceiver) AdSelectionManager.selectAds(AdSelectionConfig,
 *     Executor, OutcomeReceiver)}
 * @param adSelectionConfig same {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} used to trigger {@link android.adservices.adselection.AdSelectionManager#selectAds(android.adservices.adselection.AdSelectionConfig,java.util.concurrent.Executor,android.os.OutcomeReceiver)      }

 * This value cannot be {@code null}.
 */

public ReportImpressionRequest(long adSelectionId, @android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig) { throw new RuntimeException("Stub!"); }

/**
 * Returns the adSelectionConfig, one of the inputs to {@link android.adservices.adselection.ReportImpressionRequest ReportImpressionRequest}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig getAdSelectionConfig() { throw new RuntimeException("Stub!"); }

/** Returns the adSelectionId, one of the inputs to {@link android.adservices.adselection.ReportImpressionRequest ReportImpressionRequest} */

public long getAdSelectionId() { throw new RuntimeException("Stub!"); }
}

