/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface WindowManager extends android.view.ViewManager {

public default void addCrossWindowBlurEnabledListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

public default void addCrossWindowBlurEnabledListener(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

public default void addProposedRotationListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.IntConsumer listener) { throw new RuntimeException("Stub!"); }

public default int addScreenRecordingCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.view.WindowMetrics getCurrentWindowMetrics() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.view.Display getDefaultDisplay();

@android.annotation.NonNull
public default android.view.WindowMetrics getMaximumWindowMetrics() { throw new RuntimeException("Stub!"); }

public default boolean isCrossWindowBlurEnabled() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.window.InputTransferToken registerBatchedSurfaceControlInputReceiver(@android.annotation.NonNull android.window.InputTransferToken hostInputTransferToken, @android.annotation.NonNull android.view.SurfaceControl surfaceControl, @android.annotation.NonNull android.view.Choreographer choreographer, @android.annotation.NonNull android.view.SurfaceControlInputReceiver receiver) { throw new RuntimeException("Stub!"); }

public default void registerTrustedPresentationListener(@android.annotation.NonNull android.os.IBinder window, @android.annotation.NonNull android.window.TrustedPresentationThresholds thresholds, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.window.InputTransferToken registerUnbatchedSurfaceControlInputReceiver(@android.annotation.NonNull android.window.InputTransferToken hostInputTransferToken, @android.annotation.NonNull android.view.SurfaceControl surfaceControl, @android.annotation.NonNull android.os.Looper looper, @android.annotation.NonNull android.view.SurfaceControlInputReceiver receiver) { throw new RuntimeException("Stub!"); }

public default void removeCrossWindowBlurEnabledListener(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

public default void removeProposedRotationListener(@android.annotation.NonNull java.util.function.IntConsumer listener) { throw new RuntimeException("Stub!"); }

public default void removeScreenRecordingCallback(@android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> callback) { throw new RuntimeException("Stub!"); }

public void removeViewImmediate(android.view.View view);

public default boolean transferTouchGesture(@android.annotation.NonNull android.window.InputTransferToken transferFromToken, @android.annotation.NonNull android.window.InputTransferToken transferToToken) { throw new RuntimeException("Stub!"); }

public default void unregisterSurfaceControlInputReceiver(@android.annotation.NonNull android.view.SurfaceControl surfaceControl) { throw new RuntimeException("Stub!"); }

public default void unregisterTrustedPresentationListener(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

public static final int COMPAT_SMALL_COVER_SCREEN_OPT_IN = 1; // 0x1

public static final java.lang.String PROPERTY_ACTIVITY_EMBEDDING_ALLOW_SYSTEM_OVERRIDE = "android.window.PROPERTY_ACTIVITY_EMBEDDING_ALLOW_SYSTEM_OVERRIDE";

public static final java.lang.String PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED = "android.window.PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED";

public static final java.lang.String PROPERTY_CAMERA_COMPAT_ALLOW_FORCE_ROTATION = "android.window.PROPERTY_CAMERA_COMPAT_ALLOW_FORCE_ROTATION";

public static final java.lang.String PROPERTY_CAMERA_COMPAT_ALLOW_REFRESH = "android.window.PROPERTY_CAMERA_COMPAT_ALLOW_REFRESH";

public static final java.lang.String PROPERTY_CAMERA_COMPAT_ENABLE_REFRESH_VIA_PAUSE = "android.window.PROPERTY_CAMERA_COMPAT_ENABLE_REFRESH_VIA_PAUSE";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_DISPLAY_ORIENTATION_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_DISPLAY_ORIENTATION_OVERRIDE";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_IGNORING_ORIENTATION_REQUEST_WHEN_LOOP_DETECTED = "android.window.PROPERTY_COMPAT_ALLOW_IGNORING_ORIENTATION_REQUEST_WHEN_LOOP_DETECTED";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_MIN_ASPECT_RATIO_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_MIN_ASPECT_RATIO_OVERRIDE";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_ORIENTATION_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_ORIENTATION_OVERRIDE";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_RESIZEABLE_ACTIVITY_OVERRIDES = "android.window.PROPERTY_COMPAT_ALLOW_RESIZEABLE_ACTIVITY_OVERRIDES";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_SANDBOXING_VIEW_BOUNDS_APIS = "android.window.PROPERTY_COMPAT_ALLOW_SANDBOXING_VIEW_BOUNDS_APIS";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_SMALL_COVER_SCREEN = "android.window.PROPERTY_COMPAT_ALLOW_SMALL_COVER_SCREEN";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_USER_ASPECT_RATIO_FULLSCREEN_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_USER_ASPECT_RATIO_FULLSCREEN_OVERRIDE";

public static final java.lang.String PROPERTY_COMPAT_ALLOW_USER_ASPECT_RATIO_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_USER_ASPECT_RATIO_OVERRIDE";

public static final java.lang.String PROPERTY_COMPAT_ENABLE_FAKE_FOCUS = "android.window.PROPERTY_COMPAT_ENABLE_FAKE_FOCUS";

public static final java.lang.String PROPERTY_COMPAT_IGNORE_REQUESTED_ORIENTATION = "android.window.PROPERTY_COMPAT_IGNORE_REQUESTED_ORIENTATION";

public static final java.lang.String PROPERTY_SUPPORTS_MULTI_INSTANCE_SYSTEM_UI = "android.window.PROPERTY_SUPPORTS_MULTI_INSTANCE_SYSTEM_UI";

public static final int SCREEN_RECORDING_STATE_NOT_VISIBLE = 0; // 0x0

public static final int SCREEN_RECORDING_STATE_VISIBLE = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class BadTokenException extends java.lang.RuntimeException {

public BadTokenException() { throw new RuntimeException("Stub!"); }

public BadTokenException(java.lang.String name) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InvalidDisplayException extends java.lang.RuntimeException {

public InvalidDisplayException() { throw new RuntimeException("Stub!"); }

public InvalidDisplayException(java.lang.String name) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class LayoutParams extends android.view.ViewGroup.LayoutParams implements android.os.Parcelable {

public LayoutParams() { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(android.os.Parcel in) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int _type) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int _type, int _flags) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int _type, int _flags, int _format) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int w, int h, int _type, int _flags, int _format) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int w, int h, int xpos, int ypos, int _type, int _flags, int _format) { super((android.view.ViewGroup.LayoutParams)null); throw new RuntimeException("Stub!"); }

public boolean areWallpaperTouchEventsEnabled() { throw new RuntimeException("Stub!"); }

public boolean canPlayMoveAnimation() { throw new RuntimeException("Stub!"); }

public final int copyFrom(android.view.WindowManager.LayoutParams o) { throw new RuntimeException("Stub!"); }

public java.lang.String debug(java.lang.String output) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getBlurBehindRadius() { throw new RuntimeException("Stub!"); }

public int getColorMode() { throw new RuntimeException("Stub!"); }

public float getDesiredHdrHeadroom() { throw new RuntimeException("Stub!"); }

public int getFitInsetsSides() { throw new RuntimeException("Stub!"); }

public int getFitInsetsTypes() { throw new RuntimeException("Stub!"); }

public boolean getFrameRateBoostOnTouchEnabled() { throw new RuntimeException("Stub!"); }

public final java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

public boolean isFitInsetsIgnoringVisibility() { throw new RuntimeException("Stub!"); }

public boolean isFrameRatePowerSavingsBalanced() { throw new RuntimeException("Stub!"); }

public boolean isHdrConversionEnabled() { throw new RuntimeException("Stub!"); }

public static boolean mayUseInputMethod(int flags) { throw new RuntimeException("Stub!"); }

public void setBlurBehindRadius(int blurBehindRadius) { throw new RuntimeException("Stub!"); }

public void setCanPlayMoveAnimation(boolean enable) { throw new RuntimeException("Stub!"); }

public void setColorMode(int colorMode) { throw new RuntimeException("Stub!"); }

public void setDesiredHdrHeadroom(float desiredHeadroom) { throw new RuntimeException("Stub!"); }

public void setFitInsetsIgnoringVisibility(boolean ignore) { throw new RuntimeException("Stub!"); }

public void setFitInsetsSides(int sides) { throw new RuntimeException("Stub!"); }

public void setFitInsetsTypes(int types) { throw new RuntimeException("Stub!"); }

public void setFrameRateBoostOnTouchEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public void setFrameRatePowerSavingsBalanced(boolean enabled) { throw new RuntimeException("Stub!"); }

public void setHdrConversionEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public final void setTitle(java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

public void setWallpaperTouchEventsEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int parcelableFlags) { throw new RuntimeException("Stub!"); }

public static final int ALPHA_CHANGED = 128; // 0x80

public static final int ANIMATION_CHANGED = 16; // 0x10

public static final float BRIGHTNESS_OVERRIDE_FULL = 1.0f;

public static final float BRIGHTNESS_OVERRIDE_NONE = -1.0f;

public static final float BRIGHTNESS_OVERRIDE_OFF = 0.0f;

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.WindowManager.LayoutParams> CREATOR;
static { CREATOR = null; }

public static final int DIM_AMOUNT_CHANGED = 32; // 0x20

public static final int DISPLAY_FLAG_DISABLE_HDR_CONVERSION = 1; // 0x1

public static final int FIRST_APPLICATION_WINDOW = 1; // 0x1

public static final int FIRST_SUB_WINDOW = 1000; // 0x3e8

public static final int FIRST_SYSTEM_WINDOW = 2000; // 0x7d0

public static final int FLAGS_CHANGED = 4; // 0x4

public static final int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1; // 0x1

public static final int FLAG_ALT_FOCUSABLE_IM = 131072; // 0x20000

public static final int FLAG_BLUR_BEHIND = 4; // 0x4

public static final int FLAG_DIM_BEHIND = 2; // 0x2

@Deprecated public static final int FLAG_DISMISS_KEYGUARD = 4194304; // 0x400000

@Deprecated public static final int FLAG_DITHER = 4096; // 0x1000

public static final int FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS = -2147483648; // 0x80000000

@Deprecated public static final int FLAG_FORCE_NOT_FULLSCREEN = 2048; // 0x800

@Deprecated public static final int FLAG_FULLSCREEN = 1024; // 0x400

public static final int FLAG_HARDWARE_ACCELERATED = 16777216; // 0x1000000

public static final int FLAG_IGNORE_CHEEK_PRESSES = 32768; // 0x8000

public static final int FLAG_KEEP_SCREEN_ON = 128; // 0x80

@Deprecated public static final int FLAG_LAYOUT_ATTACHED_IN_DECOR = 1073741824; // 0x40000000

@Deprecated public static final int FLAG_LAYOUT_INSET_DECOR = 65536; // 0x10000

@Deprecated public static final int FLAG_LAYOUT_IN_OVERSCAN = 33554432; // 0x2000000

public static final int FLAG_LAYOUT_IN_SCREEN = 256; // 0x100

public static final int FLAG_LAYOUT_NO_LIMITS = 512; // 0x200

public static final int FLAG_LOCAL_FOCUS_MODE = 268435456; // 0x10000000

public static final int FLAG_NOT_FOCUSABLE = 8; // 0x8

public static final int FLAG_NOT_TOUCHABLE = 16; // 0x10

public static final int FLAG_NOT_TOUCH_MODAL = 32; // 0x20

public static final int FLAG_SCALED = 16384; // 0x4000

public static final int FLAG_SECURE = 8192; // 0x2000

public static final int FLAG_SHOW_WALLPAPER = 1048576; // 0x100000

@Deprecated public static final int FLAG_SHOW_WHEN_LOCKED = 524288; // 0x80000

public static final int FLAG_SPLIT_TOUCH = 8388608; // 0x800000

@Deprecated public static final int FLAG_TOUCHABLE_WHEN_WAKING = 64; // 0x40

@Deprecated public static final int FLAG_TRANSLUCENT_NAVIGATION = 134217728; // 0x8000000

@Deprecated public static final int FLAG_TRANSLUCENT_STATUS = 67108864; // 0x4000000

@Deprecated public static final int FLAG_TURN_SCREEN_ON = 2097152; // 0x200000

public static final int FLAG_WATCH_OUTSIDE_TOUCH = 262144; // 0x40000

public static final int FORMAT_CHANGED = 8; // 0x8

public static final int LAST_APPLICATION_WINDOW = 99; // 0x63

public static final int LAST_SUB_WINDOW = 1999; // 0x7cf

public static final int LAST_SYSTEM_WINDOW = 2999; // 0xbb7

public static final int LAYOUT_CHANGED = 1; // 0x1

public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS = 3; // 0x3

public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_DEFAULT = 0; // 0x0

public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_NEVER = 2; // 0x2

public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES = 1; // 0x1

public static final int MEMORY_TYPE_CHANGED = 256; // 0x100

@Deprecated public static final int MEMORY_TYPE_GPU = 2; // 0x2

@Deprecated public static final int MEMORY_TYPE_HARDWARE = 1; // 0x1

@Deprecated public static final int MEMORY_TYPE_NORMAL = 0; // 0x0

@Deprecated public static final int MEMORY_TYPE_PUSH_BUFFERS = 3; // 0x3

public static final int ROTATION_ANIMATION_CHANGED = 4096; // 0x1000

public static final int ROTATION_ANIMATION_CROSSFADE = 1; // 0x1

public static final int ROTATION_ANIMATION_JUMPCUT = 2; // 0x2

public static final int ROTATION_ANIMATION_ROTATE = 0; // 0x0

public static final int ROTATION_ANIMATION_SEAMLESS = 3; // 0x3

public static final int SCREEN_BRIGHTNESS_CHANGED = 2048; // 0x800

public static final int SCREEN_ORIENTATION_CHANGED = 1024; // 0x400

public static final int SOFT_INPUT_ADJUST_NOTHING = 48; // 0x30

public static final int SOFT_INPUT_ADJUST_PAN = 32; // 0x20

@Deprecated public static final int SOFT_INPUT_ADJUST_RESIZE = 16; // 0x10

public static final int SOFT_INPUT_ADJUST_UNSPECIFIED = 0; // 0x0

public static final int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256; // 0x100

public static final int SOFT_INPUT_MASK_ADJUST = 240; // 0xf0

public static final int SOFT_INPUT_MASK_STATE = 15; // 0xf

public static final int SOFT_INPUT_MODE_CHANGED = 512; // 0x200

public static final int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3; // 0x3

public static final int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5; // 0x5

public static final int SOFT_INPUT_STATE_HIDDEN = 2; // 0x2

public static final int SOFT_INPUT_STATE_UNCHANGED = 1; // 0x1

public static final int SOFT_INPUT_STATE_UNSPECIFIED = 0; // 0x0

public static final int SOFT_INPUT_STATE_VISIBLE = 4; // 0x4

public static final int TITLE_CHANGED = 64; // 0x40

public static final int TYPE_ACCESSIBILITY_OVERLAY = 2032; // 0x7f0

public static final int TYPE_APPLICATION = 2; // 0x2

public static final int TYPE_APPLICATION_ATTACHED_DIALOG = 1003; // 0x3eb

public static final int TYPE_APPLICATION_MEDIA = 1001; // 0x3e9

public static final int TYPE_APPLICATION_OVERLAY = 2038; // 0x7f6

public static final int TYPE_APPLICATION_PANEL = 1000; // 0x3e8

public static final int TYPE_APPLICATION_STARTING = 3; // 0x3

public static final int TYPE_APPLICATION_SUB_PANEL = 1002; // 0x3ea

public static final int TYPE_BASE_APPLICATION = 1; // 0x1

public static final int TYPE_CHANGED = 2; // 0x2

public static final int TYPE_DRAWN_APPLICATION = 4; // 0x4

public static final int TYPE_INPUT_METHOD = 2011; // 0x7db

public static final int TYPE_INPUT_METHOD_DIALOG = 2012; // 0x7dc

public static final int TYPE_KEYGUARD_DIALOG = 2009; // 0x7d9

@Deprecated public static final int TYPE_PHONE = 2002; // 0x7d2

@Deprecated public static final int TYPE_PRIORITY_PHONE = 2007; // 0x7d7

public static final int TYPE_PRIVATE_PRESENTATION = 2030; // 0x7ee

public static final int TYPE_SEARCH_BAR = 2001; // 0x7d1

public static final int TYPE_STATUS_BAR = 2000; // 0x7d0

@Deprecated public static final int TYPE_SYSTEM_ALERT = 2003; // 0x7d3

public static final int TYPE_SYSTEM_DIALOG = 2008; // 0x7d8

@Deprecated public static final int TYPE_SYSTEM_ERROR = 2010; // 0x7da

@Deprecated public static final int TYPE_SYSTEM_OVERLAY = 2006; // 0x7d6

@Deprecated public static final int TYPE_TOAST = 2005; // 0x7d5

public static final int TYPE_WALLPAPER = 2013; // 0x7dd

public float alpha = 1.0f;

public float buttonBrightness = -1.0f;

public float dimAmount = 1.0f;

@android.view.ViewDebug.ExportedProperty(flagMapping={@android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_ALLOW_LOCK_WHILE_SCREEN_ON, equals=android.view.WindowManager.LayoutParams.FLAG_ALLOW_LOCK_WHILE_SCREEN_ON, name="ALLOW_LOCK_WHILE_SCREEN_ON"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_DIM_BEHIND, equals=android.view.WindowManager.LayoutParams.FLAG_DIM_BEHIND, name="DIM_BEHIND"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_BLUR_BEHIND, equals=android.view.WindowManager.LayoutParams.FLAG_BLUR_BEHIND, name="BLUR_BEHIND"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, equals=android.view.WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, name="NOT_FOCUSABLE"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE, equals=android.view.WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE, name="NOT_TOUCHABLE"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL, equals=android.view.WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL, name="NOT_TOUCH_MODAL"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_TOUCHABLE_WHEN_WAKING, equals=android.view.WindowManager.LayoutParams.FLAG_TOUCHABLE_WHEN_WAKING, name="TOUCHABLE_WHEN_WAKING"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, equals=android.view.WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, name="KEEP_SCREEN_ON"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN, equals=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN, name="LAYOUT_IN_SCREEN"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS, equals=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS, name="LAYOUT_NO_LIMITS"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_FULLSCREEN, equals=android.view.WindowManager.LayoutParams.FLAG_FULLSCREEN, name="FULLSCREEN"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN, equals=android.view.WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN, name="FORCE_NOT_FULLSCREEN"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_DITHER, equals=android.view.WindowManager.LayoutParams.FLAG_DITHER, name="DITHER"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_SECURE, equals=android.view.WindowManager.LayoutParams.FLAG_SECURE, name="SECURE"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_SCALED, equals=android.view.WindowManager.LayoutParams.FLAG_SCALED, name="SCALED"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_IGNORE_CHEEK_PRESSES, equals=android.view.WindowManager.LayoutParams.FLAG_IGNORE_CHEEK_PRESSES, name="IGNORE_CHEEK_PRESSES"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_INSET_DECOR, equals=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_INSET_DECOR, name="LAYOUT_INSET_DECOR"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM, equals=android.view.WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM, name="ALT_FOCUSABLE_IM"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH, equals=android.view.WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH, name="WATCH_OUTSIDE_TOUCH"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED, equals=android.view.WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED, name="SHOW_WHEN_LOCKED"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_SHOW_WALLPAPER, equals=android.view.WindowManager.LayoutParams.FLAG_SHOW_WALLPAPER, name="SHOW_WALLPAPER"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON, equals=android.view.WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON, name="TURN_SCREEN_ON"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD, equals=android.view.WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD, name="DISMISS_KEYGUARD"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_SPLIT_TOUCH, equals=android.view.WindowManager.LayoutParams.FLAG_SPLIT_TOUCH, name="SPLIT_TOUCH"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED, equals=android.view.WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED, name="HARDWARE_ACCELERATED"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_IN_OVERSCAN, equals=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_IN_OVERSCAN, name="LOCAL_FOCUS_MODE"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS, equals=android.view.WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS, name="TRANSLUCENT_STATUS"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION, equals=android.view.WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION, name="TRANSLUCENT_NAVIGATION"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LOCAL_FOCUS_MODE, equals=android.view.WindowManager.LayoutParams.FLAG_LOCAL_FOCUS_MODE, name="LOCAL_FOCUS_MODE"), @android.view.ViewDebug.FlagToString(mask=0x20000000, equals=0x20000000, name="FLAG_SLIPPERY"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_ATTACHED_IN_DECOR, equals=android.view.WindowManager.LayoutParams.FLAG_LAYOUT_ATTACHED_IN_DECOR, name="FLAG_LAYOUT_ATTACHED_IN_DECOR"), @android.view.ViewDebug.FlagToString(mask=android.view.WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS, equals=android.view.WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS, name="DRAWS_SYSTEM_BAR_BACKGROUNDS")}, formatToHexString=true) public int flags;

public int format;

public int gravity;

public float horizontalMargin;

@android.view.ViewDebug.ExportedProperty public float horizontalWeight;

public int layoutInDisplayCutoutMode = 0; // 0x0

@Deprecated public int memoryType;

public java.lang.String packageName;

public boolean preferMinimalPostProcessing = false;

public int preferredDisplayModeId;

public float preferredRefreshRate;

public int rotationAnimation = 0; // 0x0

public float screenBrightness = -1.0f;

public int screenOrientation = -1; // 0xffffffff

public int softInputMode;

@Deprecated public int systemUiVisibility;

public android.os.IBinder token;

@android.view.ViewDebug.ExportedProperty(mapping={@android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_BASE_APPLICATION, to="BASE_APPLICATION"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION, to="APPLICATION"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_STARTING, to="APPLICATION_STARTING"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_DRAWN_APPLICATION, to="DRAWN_APPLICATION"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_PANEL, to="APPLICATION_PANEL"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_MEDIA, to="APPLICATION_MEDIA"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_SUB_PANEL, to="APPLICATION_SUB_PANEL"), @android.view.ViewDebug.IntToString(from=0x3ed, to="APPLICATION_ABOVE_SUB_PANEL"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_ATTACHED_DIALOG, to="APPLICATION_ATTACHED_DIALOG"), @android.view.ViewDebug.IntToString(from=0x3ec, to="APPLICATION_MEDIA_OVERLAY"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_STATUS_BAR, to="STATUS_BAR"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_SEARCH_BAR, to="SEARCH_BAR"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_PHONE, to="PHONE"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_SYSTEM_ALERT, to="SYSTEM_ALERT"), @android.view.ViewDebug.IntToString(from=0x7d4, to="KEYGUARD"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_TOAST, to="TOAST"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_SYSTEM_OVERLAY, to="SYSTEM_OVERLAY"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_PRIORITY_PHONE, to="PRIORITY_PHONE"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_SYSTEM_DIALOG, to="SYSTEM_DIALOG"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_KEYGUARD_DIALOG, to="KEYGUARD_DIALOG"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_SYSTEM_ERROR, to="SYSTEM_ERROR"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_INPUT_METHOD, to="INPUT_METHOD"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_INPUT_METHOD_DIALOG, to="INPUT_METHOD_DIALOG"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_WALLPAPER, to="WALLPAPER"), @android.view.ViewDebug.IntToString(from=0x7de, to="STATUS_BAR_PANEL"), @android.view.ViewDebug.IntToString(from=0x7df, to="SECURE_SYSTEM_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7e0, to="DRAG"), @android.view.ViewDebug.IntToString(from=0x7e1, to="STATUS_BAR_SUB_PANEL"), @android.view.ViewDebug.IntToString(from=0x7e2, to="POINTER"), @android.view.ViewDebug.IntToString(from=0x7e3, to="NAVIGATION_BAR"), @android.view.ViewDebug.IntToString(from=0x7e4, to="VOLUME_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7e5, to="BOOT_PROGRESS"), @android.view.ViewDebug.IntToString(from=0x7e6, to="INPUT_CONSUMER"), @android.view.ViewDebug.IntToString(from=0x7e8, to="NAVIGATION_BAR_PANEL"), @android.view.ViewDebug.IntToString(from=0x7ea, to="DISPLAY_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7eb, to="MAGNIFICATION_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7f5, to="PRESENTATION"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_PRIVATE_PRESENTATION, to="PRIVATE_PRESENTATION"), @android.view.ViewDebug.IntToString(from=0x7ef, to="VOICE_INTERACTION"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_ACCESSIBILITY_OVERLAY, to="ACCESSIBILITY_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7f1, to="VOICE_INTERACTION_STARTING"), @android.view.ViewDebug.IntToString(from=0x7f2, to="DOCK_DIVIDER"), @android.view.ViewDebug.IntToString(from=0x7f3, to="QS_DIALOG"), @android.view.ViewDebug.IntToString(from=0x7f4, to="SCREENSHOT"), @android.view.ViewDebug.IntToString(from=android.view.WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY, to="APPLICATION_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7f7, to="ACCESSIBILITY_MAGNIFICATION_OVERLAY"), @android.view.ViewDebug.IntToString(from=0x7f8, to="NOTIFICATION_SHADE"), @android.view.ViewDebug.IntToString(from=0x7f9, to="STATUS_BAR_ADDITIONAL")}) public int type;

public float verticalMargin;

@android.view.ViewDebug.ExportedProperty public float verticalWeight;

public int windowAnimations;

@android.view.ViewDebug.ExportedProperty public int x;

@android.view.ViewDebug.ExportedProperty public int y;
}

}

