/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SurfaceControl implements android.os.Parcelable {

SurfaceControl() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public boolean isValid() { throw new RuntimeException("Stub!"); }

public void readFromParcel(android.os.Parcel in) { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int BUFFER_TRANSFORM_IDENTITY = 0; // 0x0

public static final int BUFFER_TRANSFORM_MIRROR_HORIZONTAL = 1; // 0x1

public static final int BUFFER_TRANSFORM_MIRROR_VERTICAL = 2; // 0x2

public static final int BUFFER_TRANSFORM_ROTATE_180 = 3; // 0x3

public static final int BUFFER_TRANSFORM_ROTATE_270 = 7; // 0x7

public static final int BUFFER_TRANSFORM_ROTATE_90 = 4; // 0x4

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.SurfaceControl> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setBufferSize(int width, int height) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setFormat(int format) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setHidden(boolean hidden) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setName(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setOpaque(boolean opaque) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Builder setParent(@android.annotation.Nullable android.view.SurfaceControl parent) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class JankData {

JankData() { throw new RuntimeException("Stub!"); }

public long getActualAppFrameTimeNanos() { throw new RuntimeException("Stub!"); }

public int getJankType() { throw new RuntimeException("Stub!"); }

public long getScheduledAppFrameTimeNanos() { throw new RuntimeException("Stub!"); }

public long getVsyncId() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int JANK_APPLICATION = 2; // 0x2

public static final int JANK_COMPOSER = 1; // 0x1

public static final int JANK_NONE = 0; // 0x0

public static final int JANK_OTHER = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnJankDataListener {

public void onJankDataAvailable(@android.annotation.NonNull java.util.List<android.view.SurfaceControl.JankData> jankData);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class OnJankDataListenerRegistration {

OnJankDataListenerRegistration() { throw new RuntimeException("Stub!"); }

public void flush() { throw new RuntimeException("Stub!"); }

public void removeAfter(long afterVsync) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Transaction implements java.io.Closeable, android.os.Parcelable {

public Transaction() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction addTransactionCommittedListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.view.SurfaceControl.TransactionCommittedListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction addTransactionCompletedListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.view.SurfaceControl.TransactionStats> listener) { throw new RuntimeException("Stub!"); }

public void apply() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction clearFrameRate(@android.annotation.NonNull android.view.SurfaceControl sc) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.view.SurfaceControl.Transaction clearTrustedPresentationCallback(@android.annotation.NonNull android.view.SurfaceControl sc) { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction merge(@android.annotation.NonNull android.view.SurfaceControl.Transaction other) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction reparent(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.view.SurfaceControl newParent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setAlpha(@android.annotation.NonNull android.view.SurfaceControl sc, float alpha) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setBuffer(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.hardware.HardwareBuffer buffer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setBuffer(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.hardware.HardwareBuffer buffer, @android.annotation.Nullable android.hardware.SyncFence fence) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setBuffer(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.hardware.HardwareBuffer buffer, @android.annotation.Nullable android.hardware.SyncFence fence, @android.annotation.Nullable java.util.function.Consumer<android.hardware.SyncFence> releaseCallback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setBufferSize(@android.annotation.NonNull android.view.SurfaceControl sc, int w, int h) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setBufferTransform(@android.annotation.NonNull android.view.SurfaceControl sc, int transform) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setContentPriority(@android.annotation.NonNull android.view.SurfaceControl sc, int priority) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setCrop(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.graphics.Rect crop) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setDamageRegion(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.graphics.Region region) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setDataSpace(@android.annotation.NonNull android.view.SurfaceControl sc, int dataspace) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setDesiredHdrHeadroom(@android.annotation.NonNull android.view.SurfaceControl sc, float desiredRatio) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setDesiredPresentTimeNanos(long desiredPresentTimeNanos) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setExtendedRangeBrightness(@android.annotation.NonNull android.view.SurfaceControl sc, float currentBufferRatio, float desiredRatio) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setFrameRate(@android.annotation.NonNull android.view.SurfaceControl sc, float frameRate, int compatibility) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setFrameRate(@android.annotation.NonNull android.view.SurfaceControl sc, float frameRate, int compatibility, int changeFrameRateStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setFrameTimeline(long vsyncId) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setGeometry(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.graphics.Rect sourceCrop, @android.annotation.Nullable android.graphics.Rect destFrame, int orientation) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setLayer(@android.annotation.NonNull android.view.SurfaceControl sc, int z) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setLuts(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.Nullable android.hardware.DisplayLuts displayLuts) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setOpaque(@android.annotation.NonNull android.view.SurfaceControl sc, boolean isOpaque) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setPosition(@android.annotation.NonNull android.view.SurfaceControl sc, float x, float y) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setScale(@android.annotation.NonNull android.view.SurfaceControl sc, float scaleX, float scaleY) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setTrustedPresentationCallback(@android.annotation.NonNull android.view.SurfaceControl sc, @android.annotation.NonNull android.view.SurfaceControl.TrustedPresentationThresholds thresholds, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.SurfaceControl.Transaction setVisibility(@android.annotation.NonNull android.view.SurfaceControl sc, boolean visible) { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.SurfaceControl.Transaction> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TransactionCommittedListener {

public void onTransactionCommitted();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TransactionStats {

TransactionStats() { throw new RuntimeException("Stub!"); }

public long getLatchTimeNanos() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.SyncFence getPresentFence() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static final class TrustedPresentationThresholds {

@Deprecated
public TrustedPresentationThresholds(float minAlpha, float minFractionRendered, int stabilityRequirementMs) { throw new RuntimeException("Stub!"); }
}

}

