/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.security.keystore;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class KeyGenParameterSpec implements java.security.spec.AlgorithmParameterSpec {

KeyGenParameterSpec() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.security.spec.AlgorithmParameterSpec getAlgorithmParameterSpec() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getAttestKeyAlias() { throw new RuntimeException("Stub!"); }

public byte[] getAttestationChallenge() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getBlockModes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Date getCertificateNotAfter() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Date getCertificateNotBefore() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.math.BigInteger getCertificateSerialNumber() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public javax.security.auth.x500.X500Principal getCertificateSubject() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getDigests() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getEncryptionPaddings() { throw new RuntimeException("Stub!"); }

public int getKeySize() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Date getKeyValidityForConsumptionEnd() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Date getKeyValidityForOriginationEnd() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Date getKeyValidityStart() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getKeystoreAlias() { throw new RuntimeException("Stub!"); }

public int getMaxUsageCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getMgf1Digests() { throw new RuntimeException("Stub!"); }

public int getPurposes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getSignaturePaddings() { throw new RuntimeException("Stub!"); }

public int getUserAuthenticationType() { throw new RuntimeException("Stub!"); }

public int getUserAuthenticationValidityDurationSeconds() { throw new RuntimeException("Stub!"); }

public boolean isDevicePropertiesAttestationIncluded() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public boolean isDigestsSpecified() { throw new RuntimeException("Stub!"); }

public boolean isInvalidatedByBiometricEnrollment() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public boolean isMgf1DigestsSpecified() { throw new RuntimeException("Stub!"); }

public boolean isRandomizedEncryptionRequired() { throw new RuntimeException("Stub!"); }

public boolean isStrongBoxBacked() { throw new RuntimeException("Stub!"); }

public boolean isUnlockedDeviceRequired() { throw new RuntimeException("Stub!"); }

public boolean isUserAuthenticationRequired() { throw new RuntimeException("Stub!"); }

public boolean isUserAuthenticationValidWhileOnBody() { throw new RuntimeException("Stub!"); }

public boolean isUserConfirmationRequired() { throw new RuntimeException("Stub!"); }

public boolean isUserPresenceRequired() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.String keystoreAlias, int purposes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec build() { throw new RuntimeException("Stub!"); }

public android.security.keystore.KeyGenParameterSpec.Builder setAlgorithmParameterSpec(@android.annotation.NonNull java.security.spec.AlgorithmParameterSpec spec) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setAttestKeyAlias(@android.annotation.Nullable java.lang.String attestKeyAlias) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setAttestationChallenge(byte[] attestationChallenge) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setBlockModes(java.lang.String... blockModes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setCertificateNotAfter(@android.annotation.NonNull java.util.Date date) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setCertificateNotBefore(@android.annotation.NonNull java.util.Date date) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setCertificateSerialNumber(@android.annotation.NonNull java.math.BigInteger serialNumber) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setCertificateSubject(@android.annotation.NonNull javax.security.auth.x500.X500Principal subject) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setDevicePropertiesAttestationIncluded(boolean devicePropertiesAttestationIncluded) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setDigests(java.lang.String... digests) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setEncryptionPaddings(java.lang.String... paddings) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setInvalidatedByBiometricEnrollment(boolean invalidateKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setIsStrongBoxBacked(boolean isStrongBoxBacked) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setKeySize(int keySize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setKeyValidityEnd(java.util.Date endDate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setKeyValidityForConsumptionEnd(java.util.Date endDate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setKeyValidityForOriginationEnd(java.util.Date endDate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setKeyValidityStart(java.util.Date startDate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setMaxUsageCount(int maxUsageCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setMgf1Digests(@android.annotation.NonNull java.lang.String... mgf1Digests) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setRandomizedEncryptionRequired(boolean required) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setSignaturePaddings(java.lang.String... paddings) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUnlockedDeviceRequired(boolean unlockedDeviceRequired) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserAuthenticationParameters(int timeout, int type) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserAuthenticationRequired(boolean required) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserAuthenticationValidWhileOnBody(boolean remainsValid) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserAuthenticationValidityDurationSeconds(int seconds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserConfirmationRequired(boolean required) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.security.keystore.KeyGenParameterSpec.Builder setUserPresenceRequired(boolean required) { throw new RuntimeException("Stub!"); }
}

}

