/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.uwb;


/**
 * UwbRangingParams encapsulates the parameters required for a UWB ranging session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbRangingParams implements android.os.Parcelable {

UwbRangingParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets the complex channel information for this session.
 *
 * @return A {@link android.ranging.uwb.UwbComplexChannel UwbComplexChannel} object containing channel and preamble index.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbComplexChannel getComplexChannel() { throw new RuntimeException("Stub!"); }

/**
 * Gets the configuration ID associated with this session.
 *
 * @return The configuration ID as an integer.

 * Value is {@link android.ranging.uwb.UwbRangingParams#CONFIG_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR}, or {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST}
 */

public int getConfigId() { throw new RuntimeException("Stub!"); }

/**
 * Gets the UWB address of the device.
 *
 * @return The {@link android.ranging.uwb.UwbAddress UwbAddress} of the device.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbAddress getDeviceAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the UwbAddress of the peer device.
 *
 * @return A {@link android.ranging.uwb.UwbAddress UwbAddress} corresponding to the peer device to range with.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbAddress getPeerAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the update rate for ranging operations.
 *
 * @return The ranging update rate.

 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 */

public int getRangingUpdateRate() { throw new RuntimeException("Stub!"); }

/**
 * Gets the session ID associated with this ranging session.
 *
 * @return The session ID as an integer.
 */

public int getSessionId() { throw new RuntimeException("Stub!"); }

/**
 * Gets session key information, if available.
 *
 * @return A byte array containing session key info, or null if not available.
 */

@android.annotation.Nullable
public byte[] getSessionKeyInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns slot duration of the session.
 *
 * @return the slot duration.

 * Value is {@link android.ranging.uwb.UwbRangingParams#DURATION_1_MS}, or {@link android.ranging.uwb.UwbRangingParams#DURATION_2_MS}
 */

public int getSlotDuration() { throw new RuntimeException("Stub!"); }

/**
 * Gets the sub-session ID if applicable for the session.
 *
 * @return The sub-session ID as an integer or {@link #SUB_SESSION_UNDEFINED} if not applicable.
 */

public int getSubSessionId() { throw new RuntimeException("Stub!"); }

/**
 * Gets sub-session key information, if available.
 *
 * @return A byte array containing sub-session key info, or null if not available.
 */

@android.annotation.Nullable
public byte[] getSubSessionKeyInfo() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * FiRa-defined multicast {@code STATIC STS DS-TWR} ranging, deferred mode, ranging interval
 * Fast (120ms), Normal (200ms), Infrequent (600ms)
 */

public static final int CONFIG_MULTICAST_DS_TWR = 2; // 0x2

/**
 * Same as {@code CONFIG_UNICAST_DS_TWR}, except P-STS individual controlee key mode is
 * enabled.
 */

public static final int CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR = 5; // 0x5

/** Same as {@code CONFIG_MULTICAST_DS_TWR}, except P-STS security mode is enabled. */

public static final int CONFIG_PROVISIONED_MULTICAST_DS_TWR = 4; // 0x4

/** Same as {@code CONFIG_UNICAST_DS_TWR}, except P-STS security mode is enabled. */

public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR = 3; // 0x3

/** Same as {@code CONFIG_ID_3}, except fast ranging interval is 96 milliseconds. */

public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST = 6; // 0x6

/**
 * FiRa-defined unicast {@code STATIC STS DS-TWR} ranging, deferred mode, ranging interval
 * Fast (120ms), Normal (240ms), Infrequent (600ms)
 */

public static final int CONFIG_UNICAST_DS_TWR = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.uwb.UwbRangingParams> CREATOR;
static { CREATOR = null; }

/** 1 millisecond slot duration */

public static final int DURATION_1_MS = 1; // 0x1

/** 2 millisecond slot duration */

public static final int DURATION_2_MS = 2; // 0x2

/** Sub session id not applicable. */

public static final int SUB_SESSION_UNDEFINED = -1; // 0xffffffff
/**
 * Builder class for creating instances of {@link android.ranging.uwb.UwbRangingParams UwbRangingParams}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new {@link android.ranging.uwb.UwbRangingParams.Builder Builder} for creating a ranging session.
 *
 * @param sessionId     A unique identifier for the session.
 * @param configId      The configuration ID for the ranging parameters.
 * Value is {@link android.ranging.uwb.UwbRangingParams#CONFIG_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR}, or {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST}
 * @param deviceAddress The {@link android.ranging.uwb.UwbAddress UwbAddress} representing the device's address.
 *                      Must be non-null.
 * @param peerAddress   The {@link android.ranging.uwb.UwbAddress UwbAddress} of the peer device.
 *                      Must be non-null.
 * @throws java.lang.IllegalArgumentException if either {@code deviceAddress} or {@code peerAddress}
 *                                  is null.
 */

public Builder(int sessionId, int configId, @android.annotation.NonNull android.ranging.uwb.UwbAddress deviceAddress, @android.annotation.NonNull android.ranging.uwb.UwbAddress peerAddress) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new instance of {@link android.ranging.uwb.UwbRangingParams UwbRangingParams}.
 *
 * @return a new instance of {@link android.ranging.uwb.UwbRangingParams UwbRangingParams} created using the current state of
 * the builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the complex channel configuration for the ranging session.
 *
 * @param complexChannel a non-null {@link android.ranging.uwb.UwbComplexChannel UwbComplexChannel} instance representing the
 *                       channel and preamble configuration. For better performance always
 *                       use a random preamble index for each ranging session.
 * @return this Builder instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided complex channel is null.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setComplexChannel(@android.annotation.NonNull android.ranging.uwb.UwbComplexChannel complexChannel) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ranging update rate for the session.
 * <p> Defaults to {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}.
 *
 * @param rate the ranging update rate, defined as one of the constants in
 *             {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate RangingUpdateRate}.
 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 * @return this Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setRangingUpdateRate(int rate) { throw new RuntimeException("Stub!"); }

/**
 * Sets the session key information for secure ranging.
 *
 * @param sessionKeyInfo a byte array containing session key information.
 * This value cannot be {@code null}.
 * @return this Builder instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided byte array is null.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSessionKeyInfo(@android.annotation.NonNull byte[] sessionKeyInfo) { throw new RuntimeException("Stub!"); }

/**
 * Sets the slot duration in milliseconds for the ranging session.
 * <p> Defaults to {@link #DURATION_2_MS}.
 *
 * @param durationMs the slot duration {@link android.ranging.uwb.UwbRangingParams.SlotDuration SlotDuration}
 * Value is {@link android.ranging.uwb.UwbRangingParams#DURATION_1_MS}, or {@link android.ranging.uwb.UwbRangingParams#DURATION_2_MS}
 * @return this Builder instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided duration is out of range.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSlotDuration(int durationMs) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sub-session ID for the ranging session.
 *
 * @param subSessionId the sub-session ID, which should be a unique identifier for the
 *                     sub-session.
 * @return this Builder instance for method chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSubSessionId(int subSessionId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sub-session key information for secure ranging.
 *
 * @param subSessionKeyInfo a byte array containing sub-session key information.
 * This value cannot be {@code null}.
 * @return this Builder instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided map is null.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSubSessionKeyInfo(@android.annotation.NonNull byte[] subSessionKeyInfo) { throw new RuntimeException("Stub!"); }
}

}

