/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.oob;

import android.util.Range;

/**
 * Represents the configuration for an Out-of-Band (OOB) initiator in a ranging session.
 * This class includes configuration options such as device handles, security level,
 * ranging mode, and interval range for setting up an OOB initiator ranging session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OobInitiatorRangingConfig extends android.ranging.RangingConfig implements android.os.Parcelable {

OobInitiatorRangingConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of DeviceHandles associated with the OOB initiator.
 *
 * @return A list of DeviceHandle objects.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.ranging.oob.DeviceHandle> getDeviceHandles() { throw new RuntimeException("Stub!"); }

/**
 * Returns the fastest requested ranging interval.
 *
 * @return The fastest interval.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getFastestRangingInterval() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging interval range configuration.
 *
 * @return The {@link android.util.Range Range} associated with this OOB initiator.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.util.Range<java.time.Duration> getRangingIntervalRange() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging mode for the session.
 *
 * @return the ranging mode.
 * <p>Possible values:
 * {@link #RANGING_MODE_AUTO}
 * {@link #RANGING_MODE_HIGH_ACCURACY}
 * {@link #RANGING_MODE_HIGH_ACCURACY_PREFERRED}
 * {@link #RANGING_MODE_FUSED}

 * Value is {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_AUTO}, {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_HIGH_ACCURACY}, {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_HIGH_ACCURACY_PREFERRED}, or {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_FUSED}
 */

public int getRangingMode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the security level set for the ranging session.
 *
 * @return the security level.
 * <p>Possible values:
 * {@link #SECURITY_LEVEL_BASIC}
 * {@link #SECURITY_LEVEL_SECURE}

 * Value is {@link android.ranging.oob.OobInitiatorRangingConfig#SECURITY_LEVEL_BASIC}, or {@link android.ranging.oob.OobInitiatorRangingConfig#SECURITY_LEVEL_SECURE}
 */

public int getSecurityLevel() { throw new RuntimeException("Stub!"); }

/**
 * Returns the slowest acceptable ranging.
 *
 * @return The slowest interval.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getSlowestRangingInterval() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.oob.OobInitiatorRangingConfig> CREATOR;
static { CREATOR = null; }

/**
 * Automatic ranging mode. Allows the system to choose the best mode.
 */

public static final int RANGING_MODE_AUTO = 0; // 0x0

/**
 * Starts ranging with all the ranging technologies both devices support.
 */

public static final int RANGING_MODE_FUSED = 3; // 0x3

/**
 * High accuracy ranging mode. No fallback allowed.
 */

public static final int RANGING_MODE_HIGH_ACCURACY = 1; // 0x1

/**
 * High accuracy ranging mode. Fallback to lower accuracy if high accuracy ranging is not
 * supported by all devices.
 */

public static final int RANGING_MODE_HIGH_ACCURACY_PREFERRED = 2; // 0x2

/**
 * Basic security level for the ranging session.
 * <p>Example usage:
 * UWB: Static-STS
 * BLE-CS: Security level one
 */

public static final int SECURITY_LEVEL_BASIC = 0; // 0x0

/**
 * Basic security level for the ranging session.
 * <p>Example usage:
 * UWB: Provisioned-STS
 * BLE-CS: Security level four
 */

public static final int SECURITY_LEVEL_SECURE = 1; // 0x1
/**
 * Builder class for creating instances of {@link android.ranging.oob.OobInitiatorRangingConfig OobInitiatorRangingConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds a DeviceHandle to the list of devices for the ranging session.
 *
 * @param deviceHandle The DeviceHandle to add.
 * This value cannot be {@code null}.
 * @return The Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder addDeviceHandle(@android.annotation.NonNull android.ranging.oob.DeviceHandle deviceHandle) { throw new RuntimeException("Stub!"); }

/**
 * Adds a list of DeviceHandle to the list of devices for the ranging session.
 *
 * @param deviceHandles The list of DeviceHandles to add.
 * This value cannot be {@code null}.
 * @return The Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder addDeviceHandles(@android.annotation.NonNull java.util.List<android.ranging.oob.DeviceHandle> deviceHandles) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of {@link android.ranging.oob.OobInitiatorRangingConfig OobInitiatorRangingConfig} with the provided parameters.
 *
 * @return A new OobInitiatorRangingConfig instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the fastest ranging interval in milliseconds.
 *
 * @param intervalMs The fastest interval in milliseconds.
 *                   Defaults to 100ms
 * This value cannot be {@code null}.
 * @return The Builder instance, for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder setFastestRangingInterval(@android.annotation.NonNull java.time.Duration intervalMs) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ranging mode for the session.
 *
 * @param rangingMode The ranging mode to set.
 *                    Defaults to {@link #RANGING_MODE_AUTO}
 * Value is {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_AUTO}, {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_HIGH_ACCURACY}, {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_HIGH_ACCURACY_PREFERRED}, or {@link android.ranging.oob.OobInitiatorRangingConfig#RANGING_MODE_FUSED}
 * @return The Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder setRangingMode(int rangingMode) { throw new RuntimeException("Stub!"); }

/**
 * Sets the security level for the ranging session.
 *
 * @param securityLevel The security level to set.
 *                      Defaults to {@link #SECURITY_LEVEL_BASIC}
 * Value is {@link android.ranging.oob.OobInitiatorRangingConfig#SECURITY_LEVEL_BASIC}, or {@link android.ranging.oob.OobInitiatorRangingConfig#SECURITY_LEVEL_SECURE}
 * @return The Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder setSecurityLevel(int securityLevel) { throw new RuntimeException("Stub!"); }

/**
 * Sets the slowest ranging interval in milliseconds.
 *
 * @param intervalMs The slowest interval in milliseconds.
 *                   Defaults to 5000ms
 * This value cannot be {@code null}.
 * @return The Builder instance, for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobInitiatorRangingConfig.Builder setSlowestRangingInterval(@android.annotation.NonNull java.time.Duration intervalMs) { throw new RuntimeException("Stub!"); }
}

}

