/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.ble.rssi;


/**
 * BleRssiRangingParams encapsulates the parameters required for a bluetooth rssi based ranging
 * session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BleRssiRangingParams implements android.os.Parcelable {

BleRssiRangingParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the Bluetooth address of the peer device.
 *
 * @return String representing the Bluetooth address.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPeerBluetoothAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging update rate.
 *
 * @return ranging update rate.

 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 */

public int getRangingUpdateRate() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.ble.rssi.BleRssiRangingParams> CREATOR;
static { CREATOR = null; }
/**
 * Builder class to create {@link android.ranging.ble.rssi.BleRssiRangingParams BleRssiRangingParams} instances.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new {@link android.ranging.ble.rssi.BleRssiRangingParams.Builder Builder} for creating a bluetooth rssi ranging session.
 *
 * <p>Valid Bluetooth hardware addresses must be upper case, in big endian byte order, and
 * in a format such as "00:11:22:33:AA:BB". The helper
 * {@see android.bluetooth.BluetoothAdapter#checkBluetoothAddress} is available to validate
 * a Bluetooth address.
 *
 * @param peerBluetoothAddress The address of the peer device must be non-null
 *                             Bluetooth address.
 *  {@see android.bluetooth.BluetoothDevice#getAddress()}
 * @throws java.lang.IllegalArgumentException if {@code peerBluetoothAddress} is null or does not
 * conform to "00:11:22:33:AA:BB" format.
 */

public Builder(@android.annotation.NonNull java.lang.String peerBluetoothAddress) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a {@link android.ranging.ble.rssi.BleRssiRangingParams BleRssiRangingParams} instance.
 *
 * @return a new {@link android.ranging.ble.rssi.BleRssiRangingParams BleRssiRangingParams}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.rssi.BleRssiRangingParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the update rate for the BLE rssi ranging session.
 * <p>Defaults to {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}
 *
 * @param updateRate the reporting frequency.
 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 * @return this {@link android.ranging.ble.rssi.BleRssiRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.rssi.BleRssiRangingParams.Builder setRangingUpdateRate(int updateRate) { throw new RuntimeException("Stub!"); }
}

}

