/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.ble.cs;

import java.util.Set;

/**
 * Represents the capabilities of the Bluetooth-based Channel Sounding (CS) ranging.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BleCsRangingCapabilities implements android.os.Parcelable {

BleCsRangingCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of the supported security levels.
 *
 * @return a {@link java.util.Set Set} of integers representing the security levels,
 * where each level is one of {@link android.ranging.ble.cs.BleCsRangingCapabilities.SecurityLevel SecurityLevel}.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_ONE}, or {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_FOUR}
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getSupportedSecurityLevels() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.ble.cs.BleCsRangingCapabilities> CREATOR;
static { CREATOR = null; }

/**
 * Security Level 4:
 * 10 ns CS RTT accuracy and CS tones with the addition of CS RTT sounding sequence or random
 * sequence payloads, and support of the Normalized Attack Detector Metric requirements.
 */

public static final int CS_SECURITY_LEVEL_FOUR = 4; // 0x4

/**
 * Security Level 1:
 * Either CS tone or CS RTT..
 */

public static final int CS_SECURITY_LEVEL_ONE = 1; // 0x1
}

