/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;

import android.ranging.oob.OobInitiatorRangingConfig;
import android.ranging.oob.OobResponderRangingConfig;
import android.ranging.raw.RawInitiatorRangingConfig;
import android.ranging.raw.RawResponderRangingConfig;

/**
 * Represents the configuration preferences for a ranging session.
 *
 * <p>The {@code RangingPreference} class allows users to specify various parameters
 * required for a ranging session, including ranging parameters, sensor fusion settings,
 * and data notification configurations. It provides a {@link android.ranging.RangingPreference.Builder Builder} to construct
 * an instance with custom configurations.</p>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingPreference implements android.os.Parcelable {

RangingPreference() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the device role.

 * @return Value is {@link android.ranging.RangingPreference#DEVICE_ROLE_RESPONDER}, or {@link android.ranging.RangingPreference#DEVICE_ROLE_INITIATOR}
 */

public int getDeviceRole() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging parameters associated with this preference.
 *
 * @return the {@link android.ranging.RangingConfig RangingConfig} or {@code null} if not set.
 */

@android.annotation.Nullable
public android.ranging.RangingConfig getRangingParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging session configuration params.
 *
 * @return a non-null {@link android.ranging.SessionConfig SessionConfig} instance.
 */

@android.annotation.NonNull
public android.ranging.SessionConfig getSessionConfig() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.RangingPreference> CREATOR;
static { CREATOR = null; }

/** The device that initiates the session. */

public static final int DEVICE_ROLE_INITIATOR = 1; // 0x1

/** The device that responds to a session. */

public static final int DEVICE_ROLE_RESPONDER = 0; // 0x0
/**
 * Builder for creating instances of {@code RangingPreference}.
 *
 * <p>This Builder class provides a flexible way to construct a {@link android.ranging.RangingPreference RangingPreference}
 * instance by setting required and optional parameters. It ensures that all necessary
 * parameters are specified and provides default values for optional configurations.</p>
 *
 * <p>Example usage:</p>
 *
 * <pre>{@code
 * RangingPreference rangingPreference = new RangingPreference.Builder(DEVICE_ROLE_RESPONDER,
 *     new RawResponderRangingParams.Builder()
 *         .setRawRangingDevice(
 *             new RawRangingDevice.Builder()
 *                 .setRangingDevice(
 *                     new RangingDevice.Builder()
 *                         .build())
 *                .setBleRssiRangingParams(
 *                new BleRssiRangingParams.Builder("AA:BB:CC:00:11:22")
 *                    .build())
 *            .build())
 *        build())
 *    .build();
 * }</pre>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a Builder instance with the required device role and {@link android.ranging.RangingConfig RangingConfig}.
 *
 * @param role          the role of the device in {@link android.ranging.RangingPreference.DeviceRole DeviceRole}
 * Value is {@link android.ranging.RangingPreference#DEVICE_ROLE_RESPONDER}, or {@link android.ranging.RangingPreference#DEVICE_ROLE_INITIATOR}
 * @param rangingConfig the {@link android.ranging.RangingConfig RangingConfig} to use.
 *                      Needs to be an instance of one of the following:
 *                      <ul>
 *                         <li>{@link android.ranging.raw.RawResponderRangingConfig RawResponderRangingConfig}</li>
 *                         <li>{@link android.ranging.raw.RawInitiatorRangingConfig RawInitiatorRangingConfig}</li>
 *                         <li>{@link android.ranging.oob.OobResponderRangingConfig OobResponderRangingConfig}</li>
 *                         <li>{@link android.ranging.oob.OobInitiatorRangingConfig OobInitiatorRangingConfig}</li>
 *                      </ul>
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException if {@code rangingParams} is null.
 */

public Builder(int role, @android.annotation.NonNull android.ranging.RangingConfig rangingConfig) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@code RangingPreference} instance.
 *
 * <p>If the {@link android.ranging.SessionConfig SessionConfig} is not set, default instances will be used.
 *
 * @return a new {@code RangingPreference} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.RangingPreference build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration parameters for the ranging session policy.
 *
 * <p>This method allows specifying additional configuration parameters encapsulated in
 * {@link android.ranging.SessionConfig SessionConfig} for fine-tuning the behavior of the ranging session.
 *
 * @param config the {@link android.ranging.SessionConfig SessionConfig}.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.RangingPreference.Builder Builder} instance.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException if {@code params} is null.
 */

@android.annotation.NonNull
public android.ranging.RangingPreference.Builder setSessionConfig(@android.annotation.NonNull android.ranging.SessionConfig config) { throw new RuntimeException("Stub!"); }
}

}

