/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p.nsd;

import android.os.Build;
import android.os.Parcelable;

/**
 * A class for creating a USD based service discovery configuration for use with
 * {@link android.net.wifi.p2p.nsd.WifiP2pServiceInfo WifiP2pServiceInfo}.<br> or {@link android.net.wifi.p2p.nsd.WifiP2pServiceRequest WifiP2pServiceRequest}.<br>
 * For the details of the configuration, refer Wi-Fi Alliance Wi-Fi Direct R2 specification
 * - Appendix H - Unsynchronized Service Discovery (as defined in Wi-Fi Aware) and section
 * 4.2.13 USD frame format.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pUsdBasedServiceConfig implements android.os.Parcelable {

public WifiP2pUsdBasedServiceConfig() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Maximum allowed length of service specific information that can be set in the USD service
 * configuration.
 * See also {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder#setServiceSpecificInfo(byte[]) Builder.setServiceSpecificInfo(byte[])}.
 */

public static int getMaxAllowedServiceSpecificInfoLength() { throw new RuntimeException("Stub!"); }

/** Get the service name of this USD service configuration. See also
 * {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder Builder}.
 *
 * @return UTF-8 string defining the service.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getServiceName() { throw new RuntimeException("Stub!"); }

/** Get the service protocol type of this USD service configuration. See also
 * {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder#setServiceProtocolType(int) Builder.setServiceProtocolType(int)}.
 *
 * @return A non-negative service layer protocol type.

 * Value is between 0 and 255 inclusive
 */

public int getServiceProtocolType() { throw new RuntimeException("Stub!"); }

/** Get the service specific info of this USD service configuration. See also
 * {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder#setServiceSpecificInfo(byte[]) Builder.setServiceSpecificInfo(byte[])} .
 *
 *
 *  @return A byte-array of service specification information, or null if unset.
 */

@android.annotation.Nullable
public byte[] getServiceSpecificInfo() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig> CREATOR;
static { CREATOR = null; }

/** Bonjour service protocol type */

public static final int SERVICE_PROTOCOL_TYPE_BONJOUR = 1; // 0x1

/** Generic service protocol type */

public static final int SERVICE_PROTOCOL_TYPE_GENERIC = 2; // 0x2
/**
 * Builder used to build {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig WifiP2pUsdBasedServiceConfig} objects for
 * USD based service discovery and advertisement.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructor for {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder Builder}.
 *
 * @param serviceName The service name defining the service. The maximum
 *                    allowed length of the service name is 100 characters.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String serviceName) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig WifiP2pUsdBasedServiceConfig} given the current requests made on the
 * builder.
 * @return {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig WifiP2pUsdBasedServiceConfig} constructed based on builder method calls.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Specify the service discovery protocol type.
 *
 * <p>
 * Optional. {@code SERVICE_PROTOCOL_TYPE_GENERIC} by default.
 *
 * @param serviceProtocolType One of the {@code SERVICE_PROTOCOL_TYPE_*} or a non-negative
 *                            number set by the service layer.
 * Value is between 0 and 255 inclusive
 * @return The builder to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder setServiceProtocolType(int serviceProtocolType) { throw new RuntimeException("Stub!"); }

/**
 * Specify service specific information content determined by the application.
 * <p>
 *     Optional. Empty by default.
 *
 * @param serviceSpecificInfo A byte-array of service-specific information available to the
 *                            application to send additional information. Users must call
 *                            {@link #getMaxAllowedServiceSpecificInfoLength()} method to
 *                            know maximum allowed legth.
 *
 * This value may be {@code null}.
 * @return The builder to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder setServiceSpecificInfo(@android.annotation.Nullable byte[] serviceSpecificInfo) { throw new RuntimeException("Stub!"); }
}

}

