/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.os.Build;
import android.os.Parcelable;

/**
 * A class representing a Wi-Fi P2P scan configuration for setting up discovery.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pDiscoveryConfig implements android.os.Parcelable {

WifiP2pDiscoveryConfig() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the frequency to scan in MHz. See {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig.Builder#setFrequencyMhz(int) Builder.setFrequencyMhz(int)}
 */

public int getFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * Get the type of this scan. See {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig.Builder#Builder(int) Builder.Builder(int)}}

 * @return Value is {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_FULL}, {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_SOCIAL}, or {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_SINGLE_FREQ}
 */

public int getScanType() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pDiscoveryConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig WifiP2pDiscoveryConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructor for {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig.Builder Builder}.
 *
 * @param scanType Type of this P2P scan.

 * Value is {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_FULL}, {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_SOCIAL}, or {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_SINGLE_FREQ}
 */

public Builder(int scanType) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig WifiP2pDiscoveryConfig} given the current requests made on the builder.
 * @return {@link android.net.wifi.p2p.WifiP2pDiscoveryConfig WifiP2pDiscoveryConfig} constructed based on builder method calls.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pDiscoveryConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Set the frequency to scan. Only applicable if the scan type is
 * {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_SCAN_SINGLE_FREQ WifiP2pManager.WIFI_P2P_SCAN_SINGLE_FREQ}.
 *
 * @param frequencyMhz Frequency to scan in MHz.
 * Value is 0 or greater
 * @return Builder for chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pDiscoveryConfig.Builder setFrequencyMhz(int frequencyMhz) { throw new RuntimeException("Stub!"); }
}

}

