/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.os.Parcelable;

/**
 * This object contains the Device Identity Resolution (DIR) Info to check if the device is a
 * previously paired device.
 * The device advertises this information in Bluetooth LE advertising packets
 * and Unsynchronized Service Discovery (USD) frames. The device receiving DIR
 * Info uses this information to identify that the peer device is a previously paired device.
 * For Details, refer Wi-Fi Alliance Wi-Fi Direct R2 specification section 3.8.2 Pairing Identity
 * and section 3.9.2.3.2 Optional Advertising Data Elements.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pDirInfo implements android.os.Parcelable {

/**
 * Constructor for Device Identity Resolution (DIR) Info generated based on the 128 bit Device
 * Identity key. For details, refer Wi-Fi Alliance Wi-Fi Direct R2 specification Table 8.
 *
 * @param macAddress The MAC address of the P2P device interface.
 * This value cannot be {@code null}.
 * @param nonce Random number of 8 octets.
 * This value cannot be {@code null}.
 * @param dirTag Resolvable identity value of 8 octets derived based on the device MAC address,
 *               device identity key and P2P device MAC address.
 *               Tag =  Truncate-64(HMAC-SHA-256(DevIk, "DIR" || P2P Device Address || Nonce))
 *

 * This value cannot be {@code null}.
 */

public WifiP2pDirInfo(@android.annotation.NonNull android.net.MacAddress macAddress, @android.annotation.NonNull byte[] nonce, @android.annotation.NonNull byte[] dirTag) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the DIR Tag value.
 * See {@link android.net.wifi.p2p.WifiP2pDirInfo WifiP2pDirInfo}
 *
 *  @return A byte-array of Tag value of size 8 octets.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getDirTag() { throw new RuntimeException("Stub!"); }

/**
 * @return the MAC address of the P2P device interface.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.MacAddress getMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Get the nonce value used to derive DIR Tag.
 * See {@link android.net.wifi.p2p.WifiP2pDirInfo WifiP2pDirInfo}
 *
 *  @return A byte-array of random number of size 8 octets.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getNonce() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pDirInfo> CREATOR;
static { CREATOR = null; }
}

